/*****************************************************************************
 * @file:         lcm_ClientStartupCtrlClient.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcm
 * @Template:     FrancaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          Franca interface file
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2019 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// lcm_ClientStartupCtrlClientIncludePart: user specific code start
//  boost::shared_ptr is used here cause by ASF interface.
#include "I_lcm_ServiceLcmDbusIf.h"
// lcm_ClientStartupCtrlClientIncludePart: user specific code end

#include "lcm_ClientStartupCtrlClient.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_CLIENT_STARTUPCTRLCLIENT
#include "trcGenProj/Header/lcm_ClientStartupCtrlClient.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcm {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::org::bosch::cm::lcm::startupcontroller;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcm/lcm_tclClientStartupCtrlClient", lcm_tclClientStartupCtrlClient, Info);


lcm_tclClientStartupCtrlClient::lcm_tclClientStartupCtrlClient(lcm_tclAppMain* baseRef)
   : Ilcm_tclClientStartupCtrlClient(baseRef)
   , _bSrvAvailable(FALSE)
   , _StartupCtrlClientProxy(StartupcontrollerProxy::createProxy("StartupCtrlClientFiPort", * this) )
{
   LOG_INFO("Constructor for lcm_tclClientStartupCtrlClient called");
   ETG_TRACE_USR1( ( "Constructor for lcm_tclClientStartupCtrlClient called" ) );
   
   // lcm_ClientStartupCtrlClientlcm_tclClientStartupCtrlClient: user specific code start
   // lcm_ClientStartupCtrlClientlcm_tclClientStartupCtrlClient: user specific code end
}

lcm_tclClientStartupCtrlClient::~lcm_tclClientStartupCtrlClient(){
   LOG_INFO("~lcm_tclClientStartupCtrlClient called");
   ETG_TRACE_USR1( ( "~lcm_tclClientStartupCtrlClient called" ) );
   // lcm_tclClientStartupCtrlClientlcm_tclClientStartupCtrlClientDest: user specific code start
   // lcm_tclClientStartupCtrlClientlcm_tclClientStartupCtrlClientDest: user specific code end
}

// ServiceAvailableIF
void lcm_tclClientStartupCtrlClient::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onAvailable(): CALLED" ) );
   if (_StartupCtrlClientProxy == proxy){
      ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient : onAvailable _StartupCtrlClientProxy " ) );

      _StartupCtrlClientProxy->sendFI_VersionGet(* this);
      _StartupCtrlClientProxy->sendStartupFailureIndicationGet(* this);
      _StartupCtrlClientProxy->sendStartupStatusGet(* this);

      _bSrvAvailable = TRUE;
   }
   // lcm_ClientStartupCtrlClientonAvailable: user specific code start
   if(_bSrvAvailable){
	   sendStartupStatusSetValue(StartupState__STARTUP_INIT);
	   _StartupCtrlClientProxy->sendStartupFailureIndicationRegister(*this);
   }
   // lcm_ClientStartupCtrlClientonAvailable: user specific code end
}

void lcm_tclClientStartupCtrlClient::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onUnavailable(): CALLED" ) );
   if (_StartupCtrlClientProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient : onUnavailable _StartupCtrlClientProxy " ) );
   }
   // lcm_ClientStartupCtrlClientonUnavailable: user specific code start
   _StartupCtrlClientProxy->sendStartupFailureIndicationDeregisterAll();
   // lcm_ClientStartupCtrlClientonUnavailable: user specific code end

}

// TimerCallbackIF
void lcm_tclClientStartupCtrlClient::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // lcm_ClientStartupCtrlClientonExpired: user specific code start
   (tVoid)payload;
   (tVoid)timer;
   // lcm_ClientStartupCtrlClientonExpired: user specific code end
}
void lcm_tclClientStartupCtrlClient::onFI_VersionError(const::boost::shared_ptr <StartupcontrollerProxy>  & proxy, const boost::shared_ptr <FI_VersionError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onFI_VersionError(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonFI_VersionError: user specific code start
   // lcm_ClientStartupCtrlClientonFI_VersionError: user specific code end
}
void lcm_tclClientStartupCtrlClient::onFI_VersionUpdate(const::boost::shared_ptr <StartupcontrollerProxy> & proxy, const boost::shared_ptr <FI_VersionUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onFI_VersionUpdate(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonFI_VersionUpdate: user specific code start
   // lcm_ClientStartupCtrlClientonFI_VersionUpdate: user specific code end
}

void lcm_tclClientStartupCtrlClient::onStartupFailureIndicationError(const::boost::shared_ptr <StartupcontrollerProxy>  & proxy, const boost::shared_ptr <StartupFailureIndicationError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onStartupFailureIndicationError(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonStartupFailureIndicationError: user specific code start
   // lcm_ClientStartupCtrlClientonStartupFailureIndicationError: user specific code end
}
void lcm_tclClientStartupCtrlClient::onStartupFailureIndicationUpdate(const::boost::shared_ptr <StartupcontrollerProxy> & proxy, const boost::shared_ptr <StartupFailureIndicationUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onStartupFailureIndicationUpdate(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonStartupFailureIndicationUpdate: user specific code start
   LCM_NULL_POINTER_CHECK( update );
   Ilcm_tclServiceLcmDbusIf *poSrvLcmDbus = dynamic_cast < Ilcm_tclServiceLcmDbusIf* >( _cpoMain->getHandler("Ilcm_tclServiceLcmDbusIf") );
   LCM_NULL_POINTER_CHECK( poSrvLcmDbus );
   if( update->hasStartupFailureIndication( ) ) {
	   const StartupFailureInfo &dbusFailureInfo = update->getStartupFailureIndication( );
       lcm_fi_tcl_StartupFailureInfo ccaFailureInfo;
       if ( dbusFailureInfo.hasFailure() ) {
            switch( dbusFailureInfo.getFailure() ){
            case StartupFailure__STARTUP_FAILURE_NONE:
                return;
            case StartupFailure__STARTUP_FAILURE_STARTUPTIME_AVAILABLE:
                ccaFailureInfo.tFailure.enType = lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE::FI_EN_SPM_U32_STARTUP_FAILURE_STARTUPTIME_AVAILABLE;
                break;
            case StartupFailure__STARTUP_FAILURE_STARTUPTIME_EXPIRED:
                ccaFailureInfo.tFailure.enType = lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE::FI_EN_SPM_U32_STARTUP_FAILURE_STARTUPTIME_EXPIRED;
                break;
            case StartupFailure__STARTUP_FAILURE_SHUTDOWN_FAILED:
                ccaFailureInfo.tFailure.enType = lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE::FI_EN_SPM_U32_STARTUP_FAILURE_SHUTDOWN_FAILED;
                break;
            case StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE:
                ccaFailureInfo.tFailure.enType = lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE::FI_EN_SPM_U32_STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE;
                break;
            case StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED:
                ccaFailureInfo.tFailure.enType = lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE::FI_EN_SPM_U32_STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED;
                break;
            default:
                ETG_TRACE_ERRMEM( ( "lcm_tclClientStartupCtrlClient::onStartupFailureIndicationUpdate: [ERROR] Unknown Failure enum: %d ", dbusFailureInfo.getFailure() ) );
                return;
            }
       }

       if ( dbusFailureInfo.hasStartupStatus() ) {
            switch( dbusFailureInfo.getStartupStatus() ){
            case StartupState__STARTUP_INIT:
                ccaFailureInfo.tState.enType = lcm_fi_tcl_e32_LCM_STARTUP_TYPE::FI_EN_SPM_U32_STARTUP_INIT;
                break;
            case StartupState__STARTUP_ACTIVE:
                ccaFailureInfo.tState.enType = lcm_fi_tcl_e32_LCM_STARTUP_TYPE::FI_EN_SPM_U32_STARTUP_ACTIVE;
                break;
            case StartupState__STARTUP_DONE:
                ccaFailureInfo.tState.enType = lcm_fi_tcl_e32_LCM_STARTUP_TYPE::FI_EN_SPM_U32_STARTUP_DONE;
                break;
            default:
                ETG_TRACE_ERRMEM( ( "lcm_tclClientStartupCtrlClient::onStartupFailureIndicationUpdate: [ERROR] Unknown StartupStatus enum: %d ", dbusFailureInfo.getStartupStatus() ) );
                return;
            }
       }

       if ( dbusFailureInfo.hasData() ) {
           ccaFailureInfo.u32Data = dbusFailureInfo.getData();
       }
       poSrvLcmDbus->sendStartupFailureIndicationStatus( ccaFailureInfo );
   }
   // lcm_ClientStartupCtrlClientonStartupFailureIndicationUpdate: user specific code end
}

void lcm_tclClientStartupCtrlClient::onStartupStatusError(const::boost::shared_ptr <StartupcontrollerProxy>  & proxy, const boost::shared_ptr <StartupStatusError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onStartupStatusError(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonStartupStatusError: user specific code start
   // lcm_ClientStartupCtrlClientonStartupStatusError: user specific code end
}
void lcm_tclClientStartupCtrlClient::onStartupStatusUpdate(const::boost::shared_ptr <StartupcontrollerProxy> & proxy, const boost::shared_ptr <StartupStatusUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "lcm_tclClientStartupCtrlClient::onStartupStatusUpdate(): CALLED" ) );
   // lcm_ClientStartupCtrlClientonStartupStatusUpdate: user specific code start
   // lcm_ClientStartupCtrlClientonStartupStatusUpdate: user specific code end
}



tVoid lcm_tclClientStartupCtrlClient::vHandleMessage(lcm_tclBaseIf::TMsg* pMsg) {
   // lcm_ClientStartupCtrlClientvHandleMessage: user specific code start
   if (pMsg->eCmd == lcm_tclBaseIf::eStartActive){
      sendStartupStatusSetValue(StartupState__STARTUP_ACTIVE);
   } else if (pMsg->eCmd == lcm_tclBaseIf::eStartDone){
      sendStartupStatusSetValue(StartupState__STARTUP_DONE);
   }


   // lcm_ClientStartupCtrlClientvHandleMessage: user specific code end
}

tVoid lcm_tclClientStartupCtrlClient::vGetReferences() {
   // lcm_ClientStartupCtrlClientvGetReferences: user specific code start
   // lcm_ClientStartupCtrlClientvGetReferences: user specific code end
}

tVoid lcm_tclClientStartupCtrlClient::vStartCommunication() {
   // lcm_ClientStartupCtrlClientvStartCommunication: user specific code start
   // lcm_ClientStartupCtrlClientvStartCommunication: user specific code end
}

tVoid lcm_tclClientStartupCtrlClient::vTraceInfo() {
   // lcm_ClientStartupCtrlClientvTraceInfo: user specific code start
   // lcm_ClientStartupCtrlClientvTraceInfo: user specific code end
}

// lcm_ClientStartupCtrlClientDefinitioPart: user specific code start
// lcm_ClientStartupCtrlClientDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcm {

