
#ifndef _LCM_CLIENTSPM_H
#define _LCM_CLIENTSPM_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcm_ClientSpm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcm
  * @Template:     CcaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA client
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "SPM_CORE_FIProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcm_ClientSpm.h"

// lcm_ClientSpmInclude: user specific code start
//  boost::shared_ptr is used here cause by ASF interface.
// lcm_ClientSpmInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcm {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::SPM_CORE_FI;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcm;

    // lcm_Server__SERVER_NAME__NameSpace: user specific code start
    // lcm_Server__SERVER_NAME__NameSpace: user specific code end

    class lcm_tclClientSpm : public Ilcm_tclClientSpm
        , public ServiceAvailableIF
        , public SysPwrModeCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        lcm_tclClientSpm(lcm_tclAppMain* baseRef);
        virtual ~lcm_tclClientSpm();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // SysPwrModeCallbackIF
        virtual void onSysPwrModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeError >& error);
        virtual void onSysPwrModeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeStatus >& status);

    private:

        ::boost::shared_ptr <SPM_CORE_FIProxy> _SpmProxy;

    public:
        virtual const tChar* getName() const { return "lcm_tclClientSpm"; }

        virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSysPwrModeGet();

        // lcm_ClientSpmDeclarationsPart: user specific code start
        // lcm_ClientSpmDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef _LCM_CLIENTSPM_H
