/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     LifecycleControlStub.h
  * \brief    Implementation of the stub for the GENIVI LifeCycleControl
  *           This can be used to set LCM properties
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __LIFECYCLECONTROLSTUB_H
#define __LIFECYCLECONTROLSTUB_H

#include <iostream>

#include "asf/core/Logger.h"

#include "org/genivi/NodeStateManager/LifecycleControlStub.h"

#include "lcm_AppMain.h"
#include "ILifeCycleControlStub.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class LifeCycleControlStub : public ILifeCycleControlStub
   , private ::org::genivi::NodeStateManager::LifecycleControl::LifecycleControlStub
{
private:
DECLARE_CLASS_LOGGER();

public:
LifeCycleControlStub(lcm_tclAppMain *poMainAppl);
virtual ~LifeCycleControlStub();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "LifeCycleControlStub" ); }
// ######################################
// LifeCycleControlStub implementation
// ######################################
virtual void onRequestNodeRestartRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::RequestNodeRestartRequest >& request);

virtual void onSetApplicationModeRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::SetApplicationModeRequest >& request);

virtual void onSetNodeStateRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::SetNodeStateRequest >& request);

virtual void onSetBootModeRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::SetBootModeRequest >& request);

virtual void onSetAppHealthStatusRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::SetAppHealthStatusRequest >& request);

virtual void onCheckLucRequiredRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::LifecycleControl::CheckLucRequiredRequest >& request);

};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __LIFECYCLECONTROLSTUB_H

