/************************************************************************
  * FILE:         ILifeCycleConsumerProxy.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _ILIFECYCLECONSUMER_PROXY_H
#define _ILIFECYCLECONSUMER_PROXY_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class ILifeCycleConsumerProxy : public lcm_tclBaseIf
{
public:
ILifeCycleConsumerProxy(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~ILifeCycleConsumerProxy(){ _poIDbusProxy = NULL; }

virtual tVoid AddLifeCycleConsumerProxy(const std::string strBusName,
                                        const std::string strObjectPath) = 0;

virtual tVoid SendAppStateChangeRequest(const tU32 u32AppId,
                                        const tU32 u32PowerData)         = 0;

virtual tBool bHandleLifeCycleRequestResponses(const tU32 u32AppId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e eNsmErrorStatus) = 0;

virtual const tChar*getIfName() const { return( "ILifeCycleConsumerProxy" ); }

protected:
IDbusProxy *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {
#endif // _ILIFECYCLECONSUMER_PROXY_H

