/************************************************************************
  * FILE:         IRecoveryClientStub.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _ILCMRECOVERYCLIENT_STUB_H
#define _ILCMRECOVERYCLIENT_STUB_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class ILcmRecoveryClientStub : public lcm_tclBaseIf
{
public:
ILcmRecoveryClientStub(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~ILcmRecoveryClientStub(){ _poIDbusProxy = NULL; }

virtual void vUnitStopped(const std::string& UnitName) = 0;

virtual void vSupervisionStateChange(tBool SupervisionActive)  = 0;

virtual const tChar*getIfName() const { return( "ILcmRecoveryClientStub" ); }

protected:
IDbusProxy   *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // _ILCMRECOVERYCLIENT_STUB_H

