/************************************************************************
  * FILE:         ILcmConsumerStub.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the LcmConsumerStub interface
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _ICONSUMER_STUB_H
#define _ICONSUMER_STUB_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;
// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
class ILcmConsumerStub : public lcm_tclBaseIf
{
public:
ILcmConsumerStub(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~ILcmConsumerStub(){ _poIDbusProxy = NULL; }

virtual void vRegisterShutdownClient(const std::string strBusName,
                                     const std::string strObjName) = 0;

   virtual tU32 u32GetAppIdByName(const std::string& strName)      = 0;

virtual const tChar*getIfName() const { return( "ILcmConsumerStub" ); }

protected:
IDbusProxy *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // _ICONSUMER_STUB_H

