/************************************************************************
  * FILE:         IDbusUnitProxy.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _IDBUSUNIT_PROXY_H
#define _IDBUSUNIT_PROXY_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class IDbusUnitProxy : public lcm_tclBaseIf
{
public:
IDbusUnitProxy(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~IDbusUnitProxy(){ _poIDbusProxy = NULL; }

virtual tVoid vAddUnitProxy(const std::string strUnitName,
                            const std::string strObjectPath) = 0;

virtual const tChar*getIfName() const { return( "IDbusUnitProxy" ); }

protected:
IDbusProxy *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // _IDBUSUNIT_PROXY_H

