/************************************************************************
  * FILE:         IDbusServiceProxy.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _IDBUSSERVICE_PROXY_H
#define _IDBUS_PROXY_H

#define _IDBUSSERVICE_PROXY_H
#include "osal_if.h"

#include "lcm_AppMain.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;
class IDbusServiceProxy : public lcm_tclBaseIf
{
public:
IDbusServiceProxy(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~IDbusServiceProxy(){ _poIDbusProxy = NULL; }

virtual tVoid vAddServiceProxy(const std::string strUnitName,
                               const std::string strObjectPath)   = 0;

virtual void vTriggerGetMainPid(const std::string strServiceName) = 0;

virtual const tChar*getIfName() const { return( "IDbusServiceProxy" ); }

protected:
IDbusProxy *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {


#endif // _IDBUSSERVICE_PROXY_H

