/************************************************************************
  * FILE:         spm_IOsLinux.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for DBus interface
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _IDBUS_PROXY_H
#define _IDBUS_PROXY_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"
#include "asf/core.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy : public lcm_tclBaseIf
{
private:
//avoid assignment
IDbusProxy & operator = (const IDbusProxy& /*proxy*/){return *this;}
protected:
// avoid copy (except for derived classes)
IDbusProxy(const IDbusProxy& proxy):lcm_tclBaseIf(proxy){}
public:
IDbusProxy(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ }
virtual ~IDbusProxy(){}

virtual void vTraceAvailability(const ::asf::core::ServiceStateChange& stateChange) = 0;

virtual void vPostLcmRequest(tU32 u32AppId,
                             tU16 u16PowerType,
                             tU32 u32PowerData1,
                             tU32 u32PowerData2)                                    = 0;

virtual std::string     unitNameEscape(const std::string UnitName)                  = 0;

virtual std::string ExtractApplicationName(const std::string strObjectName)         = 0;

virtual std::string  strGetJobNameByServiceName(const std::string& strServiceName)  = 0;

virtual std::string  strGetServiceNameByJobName(const std::string& strJobName)      = 0;

virtual tVoid vAddJob(const std::string& strServiceName,
                      const std::string& strJobName)                                = 0;

virtual tVoid vSetJobStarted(const std::string& strJobName)                         = 0;

virtual tVoid vSetJobDone(const std::string& strJobName)                            = 0;

virtual tVoid vSetJobError(const std::string& strJobName)                           = 0;

virtual tBool bSetServiceName(const std::string& strServiceName,
                              const std::string& strJobName)                        = 0;

virtual const tChar*getIfName() const { return( "IDbusProxy" ); }
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // _IDBUS_PROXY_H

