/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         IApplicationConfiguration.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#if !defined SPM_IAPPLICATIONCONFIGURATION_H
#define SPM_IAPPLICATIONCONFIGURATION_H

#include <map>
#include <string>

#define SPM_LCM_STATE_LCM_RUN      0
#define SPM_LCM_STATE_OFF          1

/*!
  *  \class ISpmApplicationConfiguration
  *  \brief This abstract class provides interfaces for application configuration. This class supplies pure virtual functions for to
          set and get new application state configuration, get new application state and profile of application state
        and get specific supervision configuration.

  */
class ISpmApplicationConfiguration
{
public:
ISpmApplicationConfiguration(){ }
virtual ~ISpmApplicationConfiguration(){ }
virtual const tChar*getIfName() const { return( "ISpmApplicationConfiguration" ); }

// trace handling
   virtual tU32 u32GetAppIdByName(const std::string& strName)              = 0;

virtual std::string strGetServiceNameByName(std::string strSwBlockName) = 0;

};


#endif // ifndef SPM_IAPPLICATIONCONFIGURATION_H

