/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     DbusUnitProxy.h
  * \brief    Implementation of the systemd UnitProxy interface
  *           This interface is used to get specific data for a certain
  *           service. A single seperate proxy needs to be created for
  *           each service.  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __LCMDBUSUNITPROXY_H
#define __LCMDBUSUNITPROXY_H

#include "asf/core/Logger.h"

#include "org/freedesktop/systemd1/UnitProxy.h"

#include "lcm_AppMain.h"
#include "IDbusUnitProxy.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class AsfUnitProxy
{
protected:
boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy > _proxy;

public:
uint32                                                              _u32ActiveStateRegisterId;
uint32                                                              _u32IdRegisterId;
std::string                                                         _unitName;
AsfUnitProxy(boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy > proxy,
             const std::string                                                 & unitName)
   : _proxy(proxy),
   _u32ActiveStateRegisterId(0),
   _u32IdRegisterId(0),
   _unitName(unitName){}
virtual ~AsfUnitProxy(){}
AsfUnitProxy& operator =(const AsfUnitProxy& rhs){
   if(this != &rhs){
      _u32ActiveStateRegisterId = rhs._u32ActiveStateRegisterId;
      _u32IdRegisterId          = rhs._u32IdRegisterId;
      _proxy                    = rhs._proxy;
      _unitName                 = rhs._unitName;
   }
   return( * this );
}

virtual const std::string getUnitName(){ return( _unitName ); }

virtual boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy > getProxy(){ return( _proxy ); }
};

typedef std::map < const boost::shared_ptr < ::asf::core::Proxy >, boost::shared_ptr < AsfUnitProxy > > AsfUnitProxyMap;

class DbusUnitProxy : public IDbusUnitProxy
   , private ::asf::core::ServiceAvailableIF
   , private ::org::freedesktop::systemd1::Unit::ActiveStateCallbackIF
   , private ::org::freedesktop::systemd1::Unit::IdCallbackIF
{
private:
AsfUnitProxyMap _unitProxyMap;

DECLARE_CLASS_LOGGER();

public:
DbusUnitProxy(lcm_tclAppMain *poMainAppl);
virtual ~DbusUnitProxy();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vAddUnitProxy(const std::string strUnitName,
                            const std::string strObjectPath);

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "DbusUnitProxy" ); }

// ######################################
// ASF-Core implementations
// ######################################
// ServiceAvailableIF implementation
virtual void onAvailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                         const ::asf::core::ServiceStateChange         & stateChange);

virtual void onUnavailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                           const ::asf::core::ServiceStateChange         & stateChange);

// ######################################
// UnitProxy implementations
// ######################################
// ActiveStatePropertyRegisterCallbackIF implementation
virtual void onActiveStateUpdate(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy >        & proxy,
                                 const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::ActiveStateUpdate >& update);

virtual void onActiveStateError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy >       & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::ActiveStateError >& error);

// IdCallbackIF implementation
virtual void onIdUpdate(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy >& proxy,
                        const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::IdUpdate > & update);

virtual void onIdError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::UnitProxy >& proxy,
                       const ::boost::shared_ptr < ::org::freedesktop::systemd1::Unit::IdError >  & error);

};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __LCMDBUSUNITPROXY_H

