/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     DbusUnitProxy.cpp
  * \brief    Implementation of the DbusUnitProxy component
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  * \todo implement the ASF callbacks "correctly" to also print content of parameter to remove LINT
  *
  * \par Copyright:
  * (c) 2013-2015 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
// include for etg support lib
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
#include "trcGenProj/Header/DbusUnitProxy.cpp.trc.h"
#endif

#include "IDbusProxy.h"

#include "DbusUnitProxy.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

using namespace ::asf::core;
using namespace ::org::freedesktop::systemd1::Unit;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcm/DbusUnitProxy", DbusUnitProxy, Info);

/**
  *  \brief constructor of the class DBusUnitProxy
  *
  *  \param [in] factory reference to the LCM-factory to get the references to other LCM classes
  *  \return class is created
  *
  *  \details constructs all stubs and permanent proxies. it checks if DBUS adress is defined
  */
DbusUnitProxy::DbusUnitProxy(lcm_tclAppMain *poMainAppl)
   : IDbusUnitProxy(poMainAppl){
   ETG_TRACE_USR1( ( "DbusUnitProxy called" ) );
}

/**
  *  \brief Destructor of class
  *
  *  \return none
  *
  *  \details remove all dynamically created clients
  */
DbusUnitProxy::~DbusUnitProxy(){
   ETG_TRACE_USR1( ( "~DbusUnitProxy called" ) );

   AsfUnitProxyMap::iterator iterUnitPos;
   for (iterUnitPos = _unitProxyMap.begin(); iterUnitPos != _unitProxyMap.end();){
      iterUnitPos->second->getProxy()->sendDeregisterAll();
      _unitProxyMap.erase(iterUnitPos++);
   }
}

/**
  *  \brief start working
  *
  *  \return
  *
  *  \details currently empty
  */
void DbusUnitProxy::vStartCommunication(){
   _poIDbusProxy = dynamic_cast < IDbusProxy* >( _cpoMain->getHandler("IDbusProxy") );
   LCM_NULL_POINTER_CHECK(_poIDbusProxy);
}           // vStartCommunication

/**
  *  \brief adds the unit- and Unit proxies
  *
  *  \param [in] strUnitName name of the unit
  *  \return none
  *
  *  \details escapes the unit name and adds the respective Unitproxy and unitproxy to the maps
  */
tVoid DbusUnitProxy::vAddUnitProxy(const std::string strUnitName,
                                   const std::string strObjectPath){

   bool                            bFound = false;
//   ahl_bEnterCritical(_hProxyListAccess);
   AsfUnitProxyMap::const_iterator iterUnitPos;

   for(iterUnitPos = _unitProxyMap.begin();
       iterUnitPos != _unitProxyMap.end();
       iterUnitPos++){
      if(iterUnitPos->second->getUnitName() == strUnitName){
         bFound = true;
         break;
      }
   }
//   ahl_bReleaseCritical(_hProxyListAccess);
   if(!bFound){
      boost::shared_ptr < UnitProxy > _UnitProxy = UnitProxy::createProxy("DBusUnitClientPort",       // portName
                                                                          "org.freedesktop.systemd1", // busName
                                                                          strObjectPath,              // objectPath
                                                                          DBUS_BUS_SYSTEM,            // busType
                                                                          * this                      // UnitAvailableIF
                                                                          );
      boost::shared_ptr < AsfUnitProxy > pAsfUnitProxy(new AsfUnitProxy(_UnitProxy, strUnitName) );
//      ahl_bEnterCritical(_hProxyListAccess);
      _unitProxyMap.insert(std::pair < const boost::shared_ptr < Proxy >, boost::shared_ptr < AsfUnitProxy > >(_UnitProxy, pAsfUnitProxy) );
//      ahl_bReleaseCritical(_hProxyListAccess);
      ETG_TRACE_USR1( ( "_unitProxyMap has now a size of %u", (tUInt)_unitProxyMap.size() ) );
   } else {
      ETG_TRACE_USR1( ( "_unitProxyMap already contains a proxy for %s", strUnitName.c_str() ) );
//      ahl_bReleaseCritical(_hProxyListAccess);
   }
   //poclStartupCommon->vSetProcId(strSwBlockName.c_str(), iterUnitPos->second->_u32ExecMainPID);
}           // vAddUnitProxy

// ######################################
// ASF-Core implementations
// ######################################
#if 1       // allow editor to collapse this section
// ServiceAvailableIF implementation

/**
  *  \brief handles all service available indications by ASF
  *
  *  \param [in] proxy pointer to the proxy where the service is now available
  *  \param [in] stateChange contains the previous and new state of the service
  *  \return Return_Description
  *
  *  \details Details
  */
   void DbusUnitProxy::onAvailable(const boost::shared_ptr < Proxy >& proxy,
                                   const ServiceStateChange         & stateChange){
      ETG_TRACE_USR1( ( "onAvailable ..........." ) );
      LCM_NULL_POINTER_CHECK(_poIDbusProxy);
      _poIDbusProxy->vTraceAvailability(stateChange);

//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      if( iterUnitPos != _unitProxyMap.end() ){
         ETG_TRACE_USR1( ( "  - %s UnitProxy is connected", iterUnitPos->second->getUnitName().c_str() ) );
         ETG_TRACE_USR1( ( "  - register attributes and events" ) );

         boost::shared_ptr < UnitProxy > unitProxy = iterUnitPos->second->getProxy();
         iterUnitPos->second->_u32ActiveStateRegisterId = (tU32)unitProxy->sendActiveStateRegister(* this);
         unitProxy->sendActiveStateGet(* this);
      }
//      ahl_bReleaseCritical(_hProxyListAccess);
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   /**
     *  \brief called if any service we are registered too is removed from DBus-Daemon
     *
     *  \param [in] proxy pointer to the proxy where the service state of the stub has been changed
     *  \param [in] stateChange structure containing the precvious and current service state
     *  \return void
     *
     *  \details Handles all actions to be taken when a service becomes unavailable.
     *  ATTENTION: This should never happen
     */
   void DbusUnitProxy::onUnavailable(const boost::shared_ptr < Proxy >& proxy,
                                     const ServiceStateChange         & stateChange){
      ETG_TRACE_USR1( ( "onUnavailable ..........." ) );
      LCM_NULL_POINTER_CHECK(_poIDbusProxy);
      _poIDbusProxy->vTraceAvailability(stateChange);

//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::const_iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      if( iterUnitPos != _unitProxyMap.end() ){
         ETG_TRACE_USR1( ( "unitProxy %s is disconnected", iterUnitPos->second->getUnitName().c_str() ) );
         boost::shared_ptr < UnitProxy > unitProxy = iterUnitPos->second->getProxy();
         unitProxy->sendActiveStateDeregister(iterUnitPos->second->_u32ActiveStateRegisterId);
      }
//      ahl_bReleaseCritical(_hProxyListAccess);
   }        // onUnavailable

#endif      // #if 1 // allow editor to collapse this section

// ######################################
// UnitProxy implementations
// ######################################
#if 1       // allow editor to collapse this section
// ActiveStatePropertyRegisterCallbackIF implementation
   void DbusUnitProxy::onActiveStateUpdate(const ::boost::shared_ptr < UnitProxy >        & proxy,
                                           const ::boost::shared_ptr < ActiveStateUpdate >& update){
      ETG_TRACE_USR1( ( "Received onActiveState: %s", update->getActiveState().c_str() ) );
//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::const_iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      std::string                     strUnitName  = "unknown";
      std::string                     strUnitState = "unknown";
      if( iterUnitPos != _unitProxyMap.end() ){
         strUnitName  = iterUnitPos->second->getUnitName();
         strUnitState = update->getActiveState();
         ETG_TRACE_USR1( ( "  - %40s - %40s", strUnitName.c_str(), strUnitState.c_str() ) );
      } else {
         ETG_TRACE_ERRMEM( ( "  No client found " ) );
      }
//      ahl_bReleaseCritical(_hProxyListAccess);

      #ifdef ___todo
         if ( ( strUnitState.compare("activating") == 0 )
              || ( strUnitState.compare("active") == 0 )
              ){
            // add new app to database
            SPM_GET_IF_REFERENCE_NEW_VAR(poAppCfg, ISpmApplicationConfiguration);
            SPM_GET_IF_REFERENCE_NEW_VAR(poclStartupCommon, ISpmStartupCommon);
            SPM_GET_IF_REFERENCE_NEW_VAR(_poclDatabase, ISpmApplicationDatabase);            

            std::string                   strSwBlockName    = poAppCfg->strGetNameByServiceName(strUnitName);
            spm_tclSoftwareBlock         *poSwBlock         = _poclDatabase->poGetSoftwareBlock(strSwBlockName);
            if ( poSwBlock == NULL ){
               // if this is a CCA application a SW should already exist
               if(strSwBlockName != "none"){
                  // no bAddAdditionalSwBlock if this service is not configured in application
                  // as also units would be added without LCM apps inside.
                  tU32 u32AppId = poAppCfg->u32GetAppIdByName(strSwBlockName);
                  poclStartupCommon->bAddAdditionalSwBlock(strSwBlockName, strUnitName, u32AppId, SPM_STARTUP_VALUE_SYSTEMD_START_TYPE);
                  poSwBlock = _poclDatabase->poGetSoftwareBlock(strSwBlockName);
               }
            }
            if ( poSwBlock != NULL ){
               poSwBlock->vSetWholeBlockLoaded();
               SPM_GET_IF_REFERENCE_NEW_VAR(poclLam, ISpmLocalAppManager);
               poclLam->vOnWholeSwBlockIsLoaded(strSwBlockName);
            } else {
               ETG_TRACE_USR1( ( "No SW block found for name %s", strSwBlockName.c_str() ) );
               //ETG_TRACE_ERRMEM( ( "No SW block found for name %s", strSwBlockName.c_str() ) );
            }
         }
      #endif   // ifdef ___todo
   } // onActiveStateUpdate

   void DbusUnitProxy::onActiveStateError(const ::boost::shared_ptr < UnitProxy >       & proxy,
                                          const ::boost::shared_ptr < ActiveStateError >& error){
      ETG_TRACE_ERRMEM( ( "Received onActiveStateError" ) );
//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::const_iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      if( iterUnitPos != _unitProxyMap.end() ){
         if(error->hasName() && error->hasMessage() ){
            std::string ErrMessage = error->getName() + ":" + error->getMessage();
            ETG_TRACE_ERRMEM( ( "  - %40s - %s",
                             iterUnitPos->second->getUnitName().c_str(),
                             ErrMessage.c_str() ) );
         } else {
            ETG_TRACE_ERRMEM( ( "  - %40s - no error message found", iterUnitPos->second->getUnitName().c_str() ) );
         }
      } else {
         ETG_TRACE_ERRMEM( ( "  No client found " ) );
      }
//            ahl_bReleaseCritical(_hProxyListAccess);
   }        // onActiveStateError

// IdPropertyRegisterCallbackIF implementation
   void DbusUnitProxy::onIdUpdate(const ::boost::shared_ptr < UnitProxy >& proxy,
                                  const ::boost::shared_ptr < IdUpdate > & update){
      ETG_TRACE_ERR( ( "Received onId: %s", update->getId().c_str() ) );
//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::const_iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      if( iterUnitPos != _unitProxyMap.end() ){
         ETG_TRACE_USR1( ( "  - %40s - %40s", iterUnitPos->second->getUnitName().c_str(), update->getId().c_str() ) );
      } else {
         ETG_TRACE_ERR( ( "  No client found " ) );
      }
//      ahl_bReleaseCritical(_hProxyListAccess);
   }

   void DbusUnitProxy::onIdError(const ::boost::shared_ptr < UnitProxy >& proxy,
                                 const ::boost::shared_ptr < IdError >  & error){
      ETG_TRACE_ERR( ( "Received onIdError" ) );
//      ahl_bEnterCritical(_hProxyListAccess);
      AsfUnitProxyMap::const_iterator iterUnitPos;
      iterUnitPos = _unitProxyMap.find(proxy);
      if( iterUnitPos != _unitProxyMap.end() ){
         if(error->hasName() && error->hasMessage() ){
            std::string ErrMessage = error->getName() + ":" + error->getMessage();
            ETG_TRACE_ERR( ( "  - %40s - %s",
                             iterUnitPos->second->getUnitName().c_str(),
                             ErrMessage.c_str() ) );
         } else {
            ETG_TRACE_ERR( ( "  - %40s - no error message found", iterUnitPos->second->getUnitName().c_str() ) );
         }
      } else {
         ETG_TRACE_ERR( ( "  No client found " ) );
      }
//            ahl_bReleaseCritical(_hProxyListAccess);
   }        // onIdError

#endif      // #if 1 // allow editor to collapse this section

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

