/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     DbusServiceProxy.h
  * \brief    Implementation of the systemd ServiceProxy interface
  *           This interface is used to get specific data for a certain
  *           service. A single seperate proxy needs to be created for
  *           each service.
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __LCMDBUSSERVICEPROXY_H
#define __LCMDBUSSERVICEPROXY_H

#include <iostream>

#include "asf/core/Logger.h"

#include "org/freedesktop/systemd1/ServiceProxy.h"

#include "lcm_AppMain.h"
#include "IDbusServiceProxy.h"
#include "ApplicationConfiguration.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class AsfServiceProxy
{
protected:
boost::shared_ptr < ::org::freedesktop::systemd1::Service::ServiceProxy > _proxy;

public:
uint32                                                                    _u32ExecMainPIDRegisterId;
uint32                                                                    _u32ExecMainPID;
std::string                                                               _serviceName;
AsfServiceProxy(boost::shared_ptr < ::org::freedesktop::systemd1::Service::ServiceProxy > proxy,
                const std::string                                                       & serviceName)
   : _proxy(proxy),
   _u32ExecMainPIDRegisterId(0),
   _u32ExecMainPID(0),
   _serviceName(serviceName){}
virtual ~AsfServiceProxy(){}
AsfServiceProxy& operator =(const AsfServiceProxy& rhs){
   if(this != &rhs){
      _u32ExecMainPIDRegisterId = rhs._u32ExecMainPIDRegisterId;
      _u32ExecMainPID           = rhs._u32ExecMainPID;
      _proxy                    = rhs._proxy;
      _serviceName              = rhs._serviceName;
   }
   return( * this );
}

virtual const std::string getServiceName(){ return( _serviceName ); }

virtual boost::shared_ptr < ::org::freedesktop::systemd1::Service::ServiceProxy > getProxy(){ return( _proxy ); }
};


typedef std::map < const boost::shared_ptr < ::asf::core::Proxy >, boost::shared_ptr < AsfServiceProxy > > AsfServiceProxyMap;

class DbusServiceProxy : public IDbusServiceProxy
   , private ::asf::core::ServiceAvailableIF
   , private ::org::freedesktop::systemd1::Service::ExecMainPIDCallbackIF
{
private:
AsfServiceProxyMap          _serviceProxyMap;
SpmApplicationConfiguration _oAppCfg;

DECLARE_CLASS_LOGGER();

public:
DbusServiceProxy(lcm_tclAppMain *poMainAppl);
virtual ~DbusServiceProxy();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vAddServiceProxy(const std::string strUnitName,
                               const std::string strObjectPath);

virtual void vTriggerGetMainPid(const std::string strServiceName);

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "DbusServiceProxy" ); }

// ######################################
// ASF-Core implementations
// ######################################
// ServiceAvailableIF implementation
virtual void onAvailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                         const ::asf::core::ServiceStateChange         & stateChange);

virtual void onUnavailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                           const ::asf::core::ServiceStateChange         & stateChange);

// ######################################
// ServiceProxy implementations
// ######################################
virtual void onExecMainPIDError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Service::ServiceProxy >    & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Service::ExecMainPIDError >& error);

virtual void onExecMainPIDUpdate(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Service::ServiceProxy >     & proxy,
                                 const ::boost::shared_ptr < ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate >& update);

};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __LCMDBUSSERVICEPROXY_H

