
/*****************************************************************************
 * FILE:         spm_ApplicationConfigurationConfig.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2021 Robert Bosch GmbH, Hildesheim
 *****************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_GlobDefs.h"
#include "lcm_AppMain.h"
#include "ApplicationConfiguration.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
   #include "trcGenProj/Header/ApplicationConfiguration.cpp.trc.h"
#endif

/*****************************************************************************
 * local #define (scope: module-local)
 *****************************************************************************/
 
 #define SPM_ADD_ASF_APP(name,systemdName,mappedId) \
      _mapAppNamesDefines[name]=mappedId; \
      _mapAppNamesServiceName[name]=systemdName;

	  
#define ASF_C_U32_APP_EXAMPLEAPP                     SPM_FRAMEWORK_MAKE_APPID_LCM(0)
#define ASF_C_U32_APP_LCMTESTAPP                     SPM_FRAMEWORK_MAKE_APPID_LCM(1)
#define ASF_C_U32_APP_HMI_MASTER                     SPM_FRAMEWORK_MAKE_APPID_LCM(2)
#define ASF_C_U32_APP_APPHMI_CARMENUE                SPM_FRAMEWORK_MAKE_APPID_LCM(3)
#define ASF_C_U32_APP_APPHMI_MEDIA                   SPM_FRAMEWORK_MAKE_APPID_LCM(4)
#define ASF_C_U32_APP_APPHMI_PHONE                   SPM_FRAMEWORK_MAKE_APPID_LCM(5)
#define ASF_C_U32_APP_APPHMI_SYSTEM                  SPM_FRAMEWORK_MAKE_APPID_LCM(6)
#define ASF_C_U32_APP_APPHMI_TESTMODE                SPM_FRAMEWORK_MAKE_APPID_LCM(7)
#define ASF_C_U32_APP_APPHMI_TUNER                   SPM_FRAMEWORK_MAKE_APPID_LCM(8)
#define ASF_C_U32_APP_APPHMI_PLAYGROUND              SPM_FRAMEWORK_MAKE_APPID_LCM(9)
#define ASF_C_U32_APP_APPHMI_HOMESCREEN              SPM_FRAMEWORK_MAKE_APPID_LCM(10)
#define ASF_C_U32_APP_APPHMI_VEHICLE                 SPM_FRAMEWORK_MAKE_APPID_LCM(11)
#define ASF_C_U32_APP_APPHMI_TELEMATICS              SPM_FRAMEWORK_MAKE_APPID_LCM(12)
#define ASF_C_U32_APP_APPHMI_NAVIGATION              SPM_FRAMEWORK_MAKE_APPID_LCM(13)
#define ASF_C_U32_APP_APPHMI_SDS                     SPM_FRAMEWORK_MAKE_APPID_LCM(14)
#define ASF_C_U32_APP_APPHMI_SXM                     SPM_FRAMEWORK_MAKE_APPID_LCM(15)
#define ASF_C_U32_APP_APPHMI_SPI                     SPM_FRAMEWORK_MAKE_APPID_LCM(16)
#define ASF_C_U32_APP_HMI_REF_MASTER                 SPM_FRAMEWORK_MAKE_APPID_LCM(17)
#define ASF_C_U32_APP_HMI_SKELETON                   SPM_FRAMEWORK_MAKE_APPID_LCM(18)
#define ASF_C_U32_APP_HMI_REF_TUNER                  SPM_FRAMEWORK_MAKE_APPID_LCM(19)
#define ASF_C_U32_APP_HMI_REF_PLAYGROUND             SPM_FRAMEWORK_MAKE_APPID_LCM(20)
#define ASF_C_U32_APP_HMI_REF_MEDIA                  SPM_FRAMEWORK_MAKE_APPID_LCM(21)
#define ASF_C_U32_APP_HMI_MULTIDISPLAY_03            SPM_FRAMEWORK_MAKE_APPID_LCM(22)
#define ASF_C_U32_APP_HMI_MULTIDISPLAY_02            SPM_FRAMEWORK_MAKE_APPID_LCM(23)
#define ASF_C_U32_APP_HMI_DEMO_ARABIC                SPM_FRAMEWORK_MAKE_APPID_LCM(24)
#define ASF_C_U32_APP_HMI_MULTIDISPLAY_01            SPM_FRAMEWORK_MAKE_APPID_LCM(25)
#define ASF_C_U32_APP_HMI_DEMO_WIDGETS               SPM_FRAMEWORK_MAKE_APPID_LCM(26)
#define ASF_C_U32_APP_HMI_TEST_01                    SPM_FRAMEWORK_MAKE_APPID_LCM(27)
#define ASF_C_U32_APP_HMI_TEST_02                    SPM_FRAMEWORK_MAKE_APPID_LCM(28)
#define ASF_C_U32_APP_HMI_TEST_04                    SPM_FRAMEWORK_MAKE_APPID_LCM(29)
#define ASF_C_U32_APP_AUDIOMANAGER                   SPM_FRAMEWORK_MAKE_APPID_LCM(30)
#define ASF_C_U32_APP_PROCAUDIO                      SPM_FRAMEWORK_MAKE_APPID_LCM(31)
#define ASF_C_U32_APP_SWU_LCM_APPLICATION            SPM_FRAMEWORK_MAKE_APPID_LCM(32)
#define ASF_C_U32_APP_DATASERVICE_APPLICATION        SPM_FRAMEWORK_MAKE_APPID_LCM(33)
#define ASF_C_U32_APP_SUGGESTION_MANAGER             SPM_FRAMEWORK_MAKE_APPID_LCM(34)
#define ASF_C_U32_APP_DTV                            SPM_FRAMEWORK_MAKE_APPID_LCM(35)
#define ASF_C_U32_APP_GENERIC_GATEWAY                SPM_FRAMEWORK_MAKE_APPID_LCM(36)
#define ASF_C_U32_APP_SXM_AUDIO                      SPM_FRAMEWORK_MAKE_APPID_LCM(37)
#define ASF_C_U32_APP_SXM_DATA                       SPM_FRAMEWORK_MAKE_APPID_LCM(38)
#define ASF_C_U32_APP_WRITE_PROFILER_APP             SPM_FRAMEWORK_MAKE_APPID_LCM(39)
#define ASF_C_U32_APP_APPHMI_CAMERA                  SPM_FRAMEWORK_MAKE_APPID_LCM(40)


SpmApplicationConfiguration::SpmApplicationConfiguration(){
    SPM_ADD_ASF_APP("ExampleApplication", "ExampleApp.service", ASF_C_U32_APP_EXAMPLEAPP);
    SPM_ADD_ASF_APP("LcmTestApplication", "LcmTestApp.service", ASF_C_U32_APP_LCMTESTAPP);
    SPM_ADD_ASF_APP("AppHmi_Master", "rbcm-apphmi_master.service", ASF_C_U32_APP_HMI_MASTER);
    SPM_ADD_ASF_APP("AppHmi_Carmenue", "rbcm-apphmi_carmenue.service", ASF_C_U32_APP_APPHMI_CARMENUE);
    SPM_ADD_ASF_APP("AppHmi_Media", "rbcm-apphmi_media.service", ASF_C_U32_APP_APPHMI_MEDIA);
    SPM_ADD_ASF_APP("AppHmi_Phone", "rbcm-apphmi_phone.service", ASF_C_U32_APP_APPHMI_PHONE);
    SPM_ADD_ASF_APP("AppHmi_System", "rbcm-apphmi_system.service", ASF_C_U32_APP_APPHMI_SYSTEM);
    SPM_ADD_ASF_APP("AppHmi_Testmode", "rbcm-apphmi_testmode.service", ASF_C_U32_APP_APPHMI_TESTMODE);
    SPM_ADD_ASF_APP("AppHmi_Tuner", "rbcm-apphmi_tuner.service", ASF_C_U32_APP_APPHMI_TUNER);
    SPM_ADD_ASF_APP("AppHmi_Playground", "rbcm-apphmi_playground.service", ASF_C_U32_APP_APPHMI_PLAYGROUND);
    SPM_ADD_ASF_APP("AppHmi_HomeScreen", "rbcm-apphmi_homescreen.service", ASF_C_U32_APP_APPHMI_HOMESCREEN);
    SPM_ADD_ASF_APP("AppHmi_Vehicle", "rbcm-apphmi_vehicle.service", ASF_C_U32_APP_APPHMI_VEHICLE);
    SPM_ADD_ASF_APP("AppHmi_Telematics", "rbcm-apphmi_telematics.service", ASF_C_U32_APP_APPHMI_TELEMATICS);
    SPM_ADD_ASF_APP("AppHmi_Navigation", "rbcm-apphmi_navigation.service", ASF_C_U32_APP_APPHMI_NAVIGATION);
    SPM_ADD_ASF_APP("AppHmi_Sds", "rbcm-apphmi_sds.service", ASF_C_U32_APP_APPHMI_SDS);
    SPM_ADD_ASF_APP("AppHmi_Sxm", "rbcm-apphmi_sxm.service", ASF_C_U32_APP_APPHMI_SXM);
    SPM_ADD_ASF_APP("AppHmi_Spi", "rbcm-apphmi_spi.service", ASF_C_U32_APP_APPHMI_SPI);
    SPM_ADD_ASF_APP("AppHmi_RefMaster", "rbcm-apphmi_refmaster.service", ASF_C_U32_APP_HMI_REF_MASTER);
    SPM_ADD_ASF_APP("AppHmi_Skeleton", "rbcm-apphmi_skeleton.service", ASF_C_U32_APP_HMI_SKELETON);
    SPM_ADD_ASF_APP("AppHmi_RefTuner", "rbcm-apphmi_reftuner.service", ASF_C_U32_APP_HMI_REF_TUNER);
    SPM_ADD_ASF_APP("AppHmi_RefPlayground", "rbcm-apphmi_refplayground.service", ASF_C_U32_APP_HMI_REF_PLAYGROUND);
    SPM_ADD_ASF_APP("AppHmi_RefMedia", "rbcm-apphmi_refmedia.service", ASF_C_U32_APP_HMI_REF_MEDIA);
    SPM_ADD_ASF_APP("AppHmi_MultiDisplay_03", "rbcm-apphmi_multidisplay_03.service", ASF_C_U32_APP_HMI_MULTIDISPLAY_03);
    SPM_ADD_ASF_APP("AppHmi_MultiDisplay_02", "rbcm-apphmi_multidisplay_02.service", ASF_C_U32_APP_HMI_MULTIDISPLAY_02);
    SPM_ADD_ASF_APP("AppHmi_DemoArabic", "rbcm-apphmi_demoarabic.service", ASF_C_U32_APP_HMI_DEMO_ARABIC);
    SPM_ADD_ASF_APP("AppHmi_MultiDisplay_01", "rbcm-apphmi_multidisplay_01.service", ASF_C_U32_APP_HMI_MULTIDISPLAY_01);
    SPM_ADD_ASF_APP("AppHmi_DemoWidgets", "rbcm-apphmi_demowidgets.service", ASF_C_U32_APP_HMI_DEMO_WIDGETS);
    SPM_ADD_ASF_APP("AppHmi_Test_01", "rbcm-apphmi_test_01.service", ASF_C_U32_APP_HMI_TEST_01);
    SPM_ADD_ASF_APP("AppHmi_Test_02", "rbcm-apphmi_test_02.service", ASF_C_U32_APP_HMI_TEST_02);
    SPM_ADD_ASF_APP("AppHmi_Test_04", "rbcm-apphmi_test_04.service", ASF_C_U32_APP_HMI_TEST_04);
    SPM_ADD_ASF_APP("audiomanager", "rbcm-audiomanager.service", ASF_C_U32_APP_AUDIOMANAGER);
    SPM_ADD_ASF_APP("PROCAUDIO", "rbcm-procaudio.service", ASF_C_U32_APP_PROCAUDIO);
    SPM_ADD_ASF_APP("SwuLcmApplication", "swupdate-lcm.service", ASF_C_U32_APP_SWU_LCM_APPLICATION);
    SPM_ADD_ASF_APP("DataservicesApplication", "DataservicesApplication.service", ASF_C_U32_APP_DATASERVICE_APPLICATION);
    SPM_ADD_ASF_APP("SuggestionManagerServer", "SuggestionManagerServer.service", ASF_C_U32_APP_SUGGESTION_MANAGER);
    SPM_ADD_ASF_APP("Fc_dtvAsf", "rbcm-procfc_dtv.service", ASF_C_U32_APP_DTV);
    SPM_ADD_ASF_APP("agw", "rbcm-procgenericgateway.service", ASF_C_U32_APP_GENERIC_GATEWAY);
    SPM_ADD_ASF_APP("SxmAudio", "rbcm-procsxm_audio.service", ASF_C_U32_APP_SXM_AUDIO);
    SPM_ADD_ASF_APP("SxmData", "rbcm-procsxm_data.service", ASF_C_U32_APP_SXM_DATA);
    SPM_ADD_ASF_APP("writeprofilerAppComponent", "rbcm-excessive-profiler.service", ASF_C_U32_APP_WRITE_PROFILER_APP);
    SPM_ADD_ASF_APP("AppHmi_Camera", "rbcm-apphmi_camera.service", ASF_C_U32_APP_APPHMI_CAMERA);

}

SpmApplicationConfiguration::~SpmApplicationConfiguration(){
}

tU32 SpmApplicationConfiguration::u32GetAppIdByName(const std::string& strName){
   tU32                                           u32AppId = (tU32)SPM_FRAMEWORK_MAKE_APPID_LCM(_mapAppNamesDefines.size() );

   std::map < std::string, tU32 >::const_iterator it;
   it = _mapAppNamesDefines.find(strName);
   if (it != _mapAppNamesDefines.end() ){
      u32AppId = it->second;
      ETG_TRACE_USR1( ( "SpmApplicationConfiguration::u32GetAppIdByName(): App %40s found --> use ID: 0x%08x.", strName.c_str(), u32AppId ) );
   } else {
      _mapAppNamesDefines[strName] = u32AppId;
      ETG_TRACE_ERRMEM( ( "SpmApplicationConfiguration::u32GetAppIdByName(): App %40s not defined --> use ID: 0x%08x.", strName.c_str(), u32AppId ) );
   }
   return( u32AppId );
}

std::string SpmApplicationConfiguration::strGetServiceNameByName(std::string strSwBlockName){
   std::string                                           strServiceName;

   std::map < std::string, std::string >::const_iterator it;

   it = _mapAppNamesServiceName.find(strSwBlockName);
   if (it != _mapAppNamesServiceName.end() ){
      strServiceName = it->second;
      ETG_TRACE_USR1( ( "SpmApplicationConfiguration::strGetServiceNameByName(): App %40s found --> use service: %s.", strSwBlockName.c_str(), strServiceName.c_str() ) );
   } else {
      strServiceName                          = ( strSwBlockName + ".service" );
      _mapAppNamesServiceName[strSwBlockName] = strServiceName;
      ETG_TRACE_USR1( ( "SpmApplicationConfiguration::strGetServiceNameByName(): App %40s not defined --> service: %s.", strSwBlockName.c_str(), strServiceName.c_str() ) );
   }
   return( strServiceName );
} // SpmApplicationConfiguration::strGetServiceNameByName

std::string SpmApplicationConfiguration::strGetNameByServiceName(std::string strServiceName){
   std::string strSwBlockName = "none";

   tBool bFound = false;
   std::map <std::string, std::string>::const_iterator it;
   for (it = _mapAppNamesServiceName.begin();
        it != _mapAppNamesServiceName.end();
        it++){
      if (it->second == strServiceName ){
         strSwBlockName = it->first;
         bFound = true;
         ETG_TRACE_USR1( ( "SpmApplicationConfiguration::strGetNameByServiceName(): service %40s found --> used by SwBlock: %s.", strServiceName.c_str(), strSwBlockName.c_str()) );
         break;
      }
   }

   if(!bFound)
   {
      ETG_TRACE_USR1( ( "SpmApplicationConfiguration::strGetNameByServiceName(): no app for service %40s defined.", strServiceName.c_str()) );
   }
   return( strSwBlockName );
}

