/*!
  * \file  spm_WorkerServerConfig_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclWorkerServerConfig_include_ext: user specific code start
// my class header
// spm_tclWorkerServerConfig_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_WorkerServerConfig_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclWorkerServerConfig_include_spm: user specific code start
#include "spm_WorkerServerConfig.h"
#include "spm_factory.h"
// spm_tclWorkerServerConfig_include_spm: user specific code end


tVoid spm_tclWorkerServerConfig::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMTESTFILLLCMWORKERQUEUE:
      {
         // Write messages into Lcm WorkerQueue to check error handling when full..
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTestFillLcmWorkerQueue' was called" ) );

         // SpmTestFillLcmWorkerQueue: user specific code start
         // fill workerqueue with some messages and then check if error handling works
         TSpmWorkerMessage oWorkerMsg;

         oWorkerMsg._clt  = dynamic_cast < ISpmWorkerClient* >( _crfFactory.getSpmObjHandler("ISpmSystemPowerManager") );
         oWorkerMsg._msg  = SPM_U32_SYSTEM_RECOVERY;
         oWorkerMsg._parm = 0;
         while(bPostMessage(oWorkerMsg) ){
         }
         // SpmTestFillLcmWorkerQueue: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclWorkerServerConfigFunction: user specific code start
     // spm_tclWorkerServerConfigFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclWorkerServerConfigFile: user specific code start
// spm_tclWorkerServerConfigFile: user specific code end

