/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_VersionInfo.h
  * @brief        This is header file contains functions to evaluate version information and
  *                  also to read or write KDS entry.
  * @copyright    (C) 2011 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------

#include "spm_IVersionInfo.h"

/*!
  *  \class spm_tclVersionInfo
  *  \brief This class reads the configuration data and writes it to the FFD if changed .
          It also updates error memory version and stores versions information like build version , customer version.

        The spm_tclFactory object creates an instance of this class.
  */
class spm_tclVersionInfo : public ISpmVersionInfo
{
private:
ISpmWorkerServer *_poclWorkerServer;

public:
spm_tclVersionInfo( const ISpmFactory& factory );
virtual ~spm_tclVersionInfo( );

virtual void TraceBuildversion( );

virtual tBool bReadKdsEntry( tU32         u32Entry,
                             tU32         u32datalength,
                             tLcmUString *ustrKDSReadData ) const;

virtual tBool bWriteKdsEntry( tU16        key,
                              tLcmUString ustrKDSWriteData,
                              tU16        length ) const;

virtual tVoid vStoreVersionInfoInEmTrace( tVoid );
virtual tVoid vUpdateErrmemVersion( tVoid );

protected:
virtual tS32 ReadFromFFD( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromFFD ) const;

virtual tS32 WriteToFFD( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoToFFD ) const;

virtual tS32 ReadFromRegistry( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const;

virtual tS32 ReadFromFile( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const;

virtual tS32 ReadFromKDS( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const;

virtual tBool CheckAndUpdateVersionInfo( ) const;

virtual tVoid vAdditionalCheck( ){}

tVoid vUpdateVersionInfo( );

virtual tVoid vStoreProjectVersionInfoInEmTrace( );

// Implementation of interface ISpmWorkerClient + ISpmBase
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args );

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual const tChar*getName( ) const { return( "spm_tclVersionInfo" ); }

private:
std::string    _strBuildVersion;
std::string    _strCustomerVersion;
std::string    _strBoardName;
std::string    _strBuildInfo;
std::string    _strEcuSparePartNumber;
std::string    _strEcuSerialNumber;

#ifdef VARIANT_S_FTR_ENABLE_INC
   std::string _strSccAppVersion;
   std::string _strSccBlVersion;
   std::string _strSccBmVersion;
#endif

tU32           _u32BoardId;

#ifdef VARIANT_S_FTR_ENABLE_CPLD
   std::string _strCpldVersion;
   tU32        _u32CpldVersion;
#endif

tBool          _bVersionChecked;
tU32           _u32NextEmTraceCheck;

};

