/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISuperVisionManager.h
  * @brief        This is header file contains interface functions for SuperVisionManager
  *               (interfaces to set CCA heart beat, heart beat, to set watchdog threads, prewarn time).
  * @copyright    (C) 2012 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IWorkerClient.h"

class ISpmWatchdog;
class ISpmSupervisionClient;

/*!
  *  \class ISpmSupervisionManager
  *  \brief This abstract class provides interfaces to set CCA heart beat and heart beat.
          This class also delivers interfaces to set watchdog threads, prewarn time, CCA heart beat interval and heart beat intervals.
  */
class ISpmSupervisionManager : public ISpmWorkerClient
   , public spm_tclActive
{
protected:
virtual tVoid vCheckCCAHeartBeat( ) = 0;

public:
ISpmSupervisionManager( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmSupervisionManager( ){ }

virtual tVoid vSetPrewarnTime( tU32 u32PreWarnTime )                    = 0;

virtual tVoid vSetCCAHeartBeatInterval( tU32 u32WdtCCAHeartBeatTime )   = 0;

virtual tVoid vSetGetpEnabled( tBool bEnabled = TRUE )                  = 0;

virtual tVoid vTerminate( ) const                                       = 0;

virtual tVoid vEnableRetriggerHwWdt( tBool bEnableTrigger )             = 0;

virtual tVoid vStartUpFinished( )                                       = 0;

virtual tVoid vTraceInfo( )                                             = 0;

virtual tVoid vAddSupervisionClient( ISpmSupervisionClient *client )    = 0;

virtual tVoid vRemoveSupervisionClient( ISpmSupervisionClient *client ) = 0;

// from spm_tclSuperVisionManagerConfig
virtual tVoid vWriteStringToErrmem( std::string pszString )             = 0;

virtual tVoid vTriggerCCAHeartBeat( )                                   = 0;

virtual tBool bIsCCAHeartBeatWarnTime( ) const                          = 0;

virtual tVoid vNewCCAHeartBeatInterval( )                               = 0;

virtual tVoid vDisableWdtRetriggering( tVoid ) = 0;

virtual const tChar*getName( ) const                                    = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSupervisionManager" ); }
};

