/*****************************************************************************
 * FILE:         spm_SysStateSupervisor.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  A software watchdog base implementation
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 23.09.13  | CM-AI/PJVW32 Kollai  | initial version
 *
 *****************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISuperVisionClient.h"

class spm_tclSysStateSupervisor : public ISpmSupervisionClient
{

public:
spm_tclSysStateSupervisor( const ISpmFactory& factory );
virtual ~spm_tclSysStateSupervisor( );

// interface functions ISpmBase
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( );

virtual tVoid vSetCount( tU32 u32Count ){
   _u32HeartBeatCount = u32Count;
}

virtual const tChar*getName( ) const { return( "spm_tclSysStateSupervisor" ); }

protected:
static tVoid vHeartBeatTimerCallback( tVoid *pArg );

tBool                   _bTimeTrackerRunning;

OSAL_tTimerHandle       _hHeartBeatTimer;

tU32                    _u32PreWarnTime;
tU32                    _u32HeartBeatCount;
tU32                    _u32WdtHeartBeatTime;

tU32                    _u32TimeStampHeartBeatTimerStarted;
tU32                    _u32TimeStampHeartBeatTimerCallbackCalled;
tU32                    _u32TimeStampHeartBeatTimerChecked;
tU32                    _u32TimeStampHeartBeatTimerCallbackExited;
tU32                    _u32TimeStampHeartBeatTimerRetriggerd;

ISpmOsalProxy          *_poclOsalProxy;
ISpmSubStateClient     *_poclSubStateHandler;
ISpmWorkerServer       *_poclWorkerServer;
ISpmSystemPowerManager *_poclSystemPowerManager;
ISpmSupervisionManager *_poclSupervisionManager;

virtual tBool bIsHeartBeatWarnTime( ) const {
   if ( ( _u32WdtHeartBeatTime > 0 ) && ( _u32HeartBeatCount == _u32WdtHeartBeatTime ) ){
      return( TRUE );
   }
   return( FALSE );
}

virtual tBool bIsHeartBeatPreWarnTime( ) const {
   if ( ( _u32WdtHeartBeatTime > 0 ) && ( _u32HeartBeatCount == _u32WdtHeartBeatTime - _u32PreWarnTime ) ){
      return( TRUE );
   }
   return( FALSE );
}

virtual tVoid vNewHeartBeatInterval( ){ ++_u32HeartBeatCount; }

virtual tVoid vTraceInfo( );

};

