/*****************************************************************************
 * FILE:         spm_StartupSupervisor.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  A software implementation to supervise startup
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 21.01.14  | CM-AI/EPB2 Kollai    | initial version
 *
 *****************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IStartupSupervisor.h"

class spm_tclStartupSupervisor : public ISpmStartupSupervisor
{

private:
ISpmWakeupHandler *_poclWakeupHandler;
ISpmWorkerServer  *_poclWorkerServer;
ISpmSystemLoadStatistics  *_poclStartupTimeStatistic;

tU8                _u8StartUpState;
tBool              _bStartMinConfig;

tU32               _u32SystemCheckUp;
tU32               _u32SystemCheckRunning;

public:
spm_tclStartupSupervisor( const ISpmFactory& factory );
virtual ~spm_tclStartupSupervisor( );

// interface functions ISpmBase
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( );

virtual tVoid vStartSupervision( ){
   _bStopSupervision = FALSE;
}

virtual tVoid vStopSupervision( ){
   _bStopSupervision = TRUE;
}

virtual tVoid vSetCount( tU32 u32Count ){
   (tVoid)u32Count;
}

virtual const tChar*getName( ) const { return( "spm_tclStartupSupervisor" ); }


// interface functions ISpmStartupSupervisor
virtual tVoid vStartupSpmProcessed( );

virtual tVoid vStartupSystemProcessed( );

virtual tVoid vClearEmergencyCounter( );

virtual tU8   u8GetStartupState( ){ return( _u8StartUpState ); }
virtual tBool bStartMinConfig( ){ return( _bStartMinConfig ); }

protected:
virtual tVoid vTraceInfo( );

};

