/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISupervisionEnableSupervisor.h
  * @brief        This is header file contains interface functions for SupervisionEnableSupervisor.
  * @copyright    (C) 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISuperVisionClient.h"
#include "spm_IFactory.h"

/*!
  *  \class ISpmSupervisionEnableSupervisor
  *  \brief This abstract class provides interfaces for spm Supervision
  *  It is used to determine if supervision is enabled (default) or not
  */
class ISpmSupervisionEnableSupervisor : public ISpmSupervisionClient
{
public:
// constructor
ISpmSupervisionEnableSupervisor( const ISpmFactory& factory ) : ISpmSupervisionClient( factory ){ }
virtual ~ISpmSupervisionEnableSupervisor( ){ }

// Implementation of interface ISpmBase
virtual const tChar*getName( ) const      = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSupervisionEnableSupervisor" ); }

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( )   = 0;

virtual tVoid vTriggerSupervisionState( ) = 0;

virtual tVoid vSupervisionStop( )         = 0;

virtual tVoid vSupervisionStart( )        = 0;

virtual tBool bIsSupervisionStopped( )    = 0;

};

