/*****************************************************************************
 * FILE:         spm_IStartupSupervisor.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  abstract interface class as base for the supervision of the start-up process
 *
 * ---------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 21.09.13  | CM-AI/PJVW32 Kollai  | initial version
 *
 *****************************************************************************/
#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ISuperVisionClient.h"
#include "spm_factory.h"

#define SPM_U8_STARTUP_STATE_INIT                      (tU8)0x00
#define SPM_U8_STARTUP_STATE_SPM_STARTED               (tU8)0x01
#define SPM_U8_STARTUP_STATE_SYSTEM_STARTED            (tU8)0x02
#define SPM_U8_STARTUP_STATE_SYSTEM_UP                 (tU8)0x03
#define SPM_U8_STARTUP_STATE_SYSTEM_STARTUPCONTROLLER  (tU8)0x04
#define SPM_U8_STARTUP_STATE_SYSTEM_RUNNING            (tU8)0x05

class ISpmStartupSupervisor : public ISpmSupervisionClient
{
public:
ISpmStartupSupervisor( const ISpmFactory& factory ) : ISpmSupervisionClient( factory ){
}

virtual ~ISpmStartupSupervisor( ){
}

virtual const tChar*getInterfaceName( ) const { return( "ISpmStartupSupervisor" ); }

virtual tVoid vStartupSpmProcessed( )    = 0;

virtual tVoid vStartupSystemProcessed( ) = 0;

virtual tVoid vClearEmergencyCounter( )  = 0;

virtual tU8   u8GetStartupState( )       = 0;

virtual tBool bStartMinConfig( )         = 0;

};

