/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_StartupSystemVariant.h
  * @brief        This is header file contains functions to add variants , evaluate process variant and calculate valid configuration.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStartupSystemVariant.h"

// //////////////////////////////////////////////////////////////////////////////
// class for the variant evaluation during startup

/*!
  *  \class spm_tclStartupSystemVariant
  *  \brief This class does variant evaluation to determine if processes, components and services are needed in the calculated configuration.
          It is used by class spm_tclStartupCommon to read variant configuration from registry , evaluats the variant expression and
        gets the list of processes to be deactivated from variant object.
  */
class spm_tclStartupSystemVariant : public ISpmStartupSystemVariant
{
public:
spm_tclStartupSystemVariant( const ISpmFactory& factory );
virtual ~spm_tclStartupSystemVariant( );

// all values are fix at startup
tVoid vAddVariable( const std::string& strName,
                    tU32               u32Value );

tVoid vAddVariable( const std::string& strName,
                    const std::string& strValue );

tVoid vEvaluateProcessVariant( );

tVoid vEvaluateProcessVariantV2( );

tVoid vCalculateValidConfiguration( );

tVoid vUpdateRegistry( );

const std::set < std::string >& oGetDisabledProcesses( ) const { return( _setDisabledProcesses ); }

tVoid vTrace( );

// ISpmBase interface
virtual tVoid vGetReferences( ){}
tVoid vStartCommunication( ){}
virtual const tChar*getName( ) const { return( "spm_tclStartupSystemVariant" ); }
virtual tVoid vHandleTraceMessage( const tUChar */* puchData */ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
TSpmVariantValue*oEvaluateValue( const std::string& strVal );

TSpmVariantValue*oEvaluateString( const std::string& str );

TSpmVariantValue*oEvaluateNumber( const std::string& strNum );

tBool bEvaluateVariantExpression( const std::map < tU32, TSpmVariantValue* >& values,
                                  const std::string& strExpression );

tVoid vDeactivateList( const std::string& strExcl );

tVoid vDeactivate( const std::string& strExcl );

private:
// these are only used during variable initialization, after that the
// variables contents are accessible via number in _var._variables.
std::map < std::string, TSpmVariantVariable > _variables;

TSpmVariant                                   _var;
std::set < std::string >                      _setDisabledProcesses;
std::set < std::string >                      _setDisabledComponents;
std::set < std::string >                      _setDisabledServices;
};

