/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_StartupLocal.h
  * @brief        This is header file contains interface functions for StartupLocal.
  *               interfaces to spawn a process and to remove a process.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_StartupSystemConfig.h"

class ISpmStartupInvestigationServer;
class ISpmProcessDatabase;
class ISpmProcessSupervision;
class ISpmCcaServiceServer;
#include <sched.h>
// //////////////////////////////////////////////////////////////////////////////
// configuration of system startup for local os

/*!
  *  \class spm_tclStartupLocal
  *  \brief This class implements configuration of system startup and process spawn. It provides interfaces to spawn a process and to
  *         remove a process. FC SPM spawns a process based on Process Start Type. The Process Start Type can be "OSAL" or "SYSTEMD".
  *         If start type of a process is "OSAL", then spawn the same using OSAL Process Spawn.
  *         If start type of a process is "SYSTEMD", them spawn the same using SYSTEMD interface(\todo).
  *
  *         The spm_tclFactory object creates an instance of this class. During process spawn,
  *         the spm_tclStartupSystem::bStartProcess(TProcConfiguration& _oConf, tU32 u32HighPrioSync) invokes bProcessSpawn method of this class.
  *
  *         This class updates process configuration information of the process getting spawned in Process Database (spm_tclProcessDatabase).
  */
class spm_tclStartupLocal : public spm_tclStartupSystemConfig
{
public:
spm_tclStartupLocal( const ISpmFactory& factory,
                     const std::string& strConfigPath,
                     const std::string& strInstance );
virtual ~spm_tclStartupLocal( );

// Implementation of interface spm_tclSystemStartup
virtual tBool bProcessSpawn( TProcConfiguration& _oConf );

virtual tVoid vRemoveProcess( TProcConfiguration& oProcConf );

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} 


virtual tVoid vRemoveSwBlock( const std::string& /*strSwBlockName*/,
                              tBool              /*bStopProcWithLastBlock*/ ){ } 
virtual tVoid vTraceProcessConfiguration( ){ }
virtual std::string strGetProcNameByBlockName( const std::string& strBlockName ){
   (tVoid)strBlockName;
   return( "" );
}

virtual std::string strGetProcLocationByBlockName( const std::string& strBlockName ){
   (tVoid)strBlockName;
   return( "" );
}
// Do nothing here just return an object
TMapProcessConfiguration _oTMapProcessConfiguration;
virtual TMapProcessConfiguration& oGetProcessConfig( ){ FATAL_M_ASSERT_ALWAYS( ); return _oTMapProcessConfiguration;} 
// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 );

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args );


virtual tBool bRenice( tS32 s32NewNiceLevel,
                       tS32 s32handle );

virtual tBool bSetNiceLevel( tS32 s32NewNiceLevel,
                             tS32 s32handle );

virtual tVoid vSetStartUpFinishedProcessConfiguration( tU32 instance );

virtual tBool bSetCpuAffinity( tS32      s32NewCpuAffinity,
                               tS32      s32handle,
                               cpu_set_t cpuMask );

protected:
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual const tChar*getName( ) const { return( "spm_tclStartupLocal" ); }

private:
ISpmProcessDatabase    *_poProcessDatabase;
ISpmWorkerServer       *_poWorkerServer;
ISpmProcessSupervision *_poclProcessSupervision;
ISpmCcaServiceServer   *_poclCcaSrv;
tBool                   _fStartUpFinishedConfigSet;
};

