/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ProcessShutdown.h
  * @brief        This is header file contains interface functions for ProcessShutdown.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_Config.h"
#include "spm_IProcessShutdown.h"

#define SPM_MSGBOX_STCOM_MAX_MESSAGE_COUNT    20
#define SPM_MSGBOX_STCOM_NAME                 "SpmStCom"
#define SPM_STCOM_MAX_STR                     256

class ISpmSyncHandler;

struct TStCommMsg
{
   tU32 u32Cmd;
   std::string szProcName;
   tU16 u16ID;
};

enum enProcessStateReq
{
   STCOMM_UNKNOWN      = 0,
   STCOMM_STOP_PROCESS = 1,
   STCOMM_INVALID
};

class ISpmStartupSystem;
class ISpmWorkerServer;

class spm_ProcessShutdown : public IProcessShutdown
{
public:
spm_ProcessShutdown( const ISpmFactory& factory );
virtual ~spm_ProcessShutdown( );

private:
ISpmStartupSystem       *_poclStartupSystem;
ISpmWorkerServer        *_srv;
ISpmSyncHandler         *_poclSyncHandler;

tBool                    _bTerminate;

OSAL_tSemHandle          _hShutdownSem;
spm_tclActive           *_actPrcShutdown;
tU32                     _u32ThreadPrio;
tU32                     _u32ThreadStack;
OSAL_tMQueueHandle       _hStCommQueue;
std::string              _strSemName;
tU16                     _u16ForcedWaitResultMsgId;
std::string              _strForcedSwBlockNameToWaitFor;
std::string              _strProcessToKill;
TBlockList               _swList;
TMapProcessConfiguration oProcConfigToKill;

public:
OSAL_tThreadID           _hThreadId;
// //////////////////////////////////////////////////////////////////////////////
// interface for a client class to work with spm_tclActive (inside a thread)
virtual tVoid vMain( ); // interface for main entry function

virtual tVoid vHandleTraceMessage( const tUChar *puchData ){ (tVoid)puchData; }
virtual const tChar*getInterfaceName( ) const {
   return( "spm_IProcessShutdown" );
}

virtual tBool bPostStopProcessRequest( const std::string& strProcName,
                                       tU16               u16ID = 0 );

virtual tVoid vHandleMsgQueue( );

virtual tVoid vCheckWaitForSync( );

protected:
// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){
}

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args );

virtual const tChar*getName( ) const {
   return( "spm_ProcessShutdown" );
}

// ISpmBase interface functioms
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

static tVoid vOnQueueCallback( tVoid *pArg );

};

