/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ProcConfig.h
  * @brief        This is header file contains info related Process Configuration.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define SPM_STARTUP_REG_TYPE_LOAD_DIRECTLY          0x00000001
#define SPM_STARTUP_REG_TYPE_PRELOAD                0x00000002
#define SPM_STARTUP_REG_TYPE_NOREG                  0x00000004
#define SPM_STARTUP_REG_TYPE_NOREG_EXT_BLOCK        0x00000008

#define PROC_START_TYPE_MAX                         20
#define PROC_UNKNOWN_PROC_ID                        - 1

struct TBlockElement
{
   std::string strBlockName;
   tU32 u32BlockConf;
   tBool bActive;
};


typedef std::list < TBlockElement > TBlockList;


struct TProcConfiguration
{
   TProcConfiguration( ){
      bProcEnabled                = FALSE;
      bProcSpawned                = FALSE;
      bPredecessorSeen            = FALSE;
      u32LastSync                 = SPM_U32_SYNC_NONE;
      u32ProcPrio                 = 0;
      u32ProcType                 = 0;
      s32ProcId                   = PROC_UNKNOWN_PROC_ID;
      u32ProcTypeArg              = 0;
      u32ProcSupervision          = 0;
      u32Affinity                 = 0;
      u32AffinityEnd              = 0;
      u32NiceLevel                = 0;
      u32NiceLevelEnd             = 0;
      u32CGroupMemLevel1          = 0;
      u32CGroupMemLevel2          = 0;
      u32RegType                  = SPM_STARTUP_REG_TYPE_LOAD_DIRECTLY;
      u32DelayBeforeStartThisProc = 0;
      u32DelayBeforeStartNextProc = 0;
      u32AbsStartTime             = 0;
      u32StartTimeRel             = 0;
      u32StartTimeAbs             = 0;

   }

   std::string strRegPath;              // path to registry
   std::string strProcStartType;        // process start type - OSAL or LINUX
   std::string strProcessName;          // process name
   std::string strProcessLocation;      // process location
   std::string strProcShutdownEvent;    // the name of the shutdown event
   std::string strProcConfigBasePath;   // complete path to process
   std::string strCGroupMemScriptPath;  // script path for memory supervision
   std::string strCGroupCpuScriptPath;  // script path for cpu reduction level supervision
   std::string strSyncPointName;        // Name of sync point to wait for
   std::string strCondition;            // Condition for startup / depending on KDS configuration
   std::string strAdditionCondition;    // Addition condition handling, e.g. Start/stop on error
   tU32 u32CGroupMemLevel1;             // level 1 to notify memory supervision process
   tU32 u32CGroupMemLevel2;             // level 2 to notify memory supervision process
   tU32 u32NiceLevel;                   // nice level during startup
   tU32 u32NiceLevelEnd;                // nice level after startup
   tBool bProcEnabled;                  // is process enabled?
   tBool bProcSpawned;                  // Was process already spawned?
   tU32 u32ProcSupervision;             // kind of supervision if process died -> 0: SystemReset, 1: ProcRestart, 2: NoAction
   tBool bPredecessorSeen;              // Predecessor entry was seen and therefore valid
   tU32 u32LastSync;                    // Synchronization with latest SW-Block
   tU32 u32ProcPrio;                    // Process priority
   tU32 u32ProcType;                    // Process type
   tU32 u32ProcTypeArg;                 // Argument for a process type if needed
   tS32 s32ProcId;                      // process ID of started process
   TBlockList listSwBlocks;             // list of contained sw blocks
   TBlockList listBlocksToSync;         // list of sw block to sync
   TSpmSwBlockSet setSwBlocksExclude;   // list of sw blocks which shall be removed from current
   // predecessor.
   tU32 u32Affinity;                    // affinity of process to cpu core during startup
   tU32 u32AffinityEnd;                 // affinity of process to cpu core after startup finished
   tU32 u32RegType;                     // if set to 1 then registry is directly loaded after
   tU32 u32DelayBeforeStartThisProc;    // delay in ms before process is spawned
   tU32 u32DelayBeforeStartNextProc;    // delay in ms after process is spawned
   tU32 u32AbsStartTime;                // absolute time in ms from system startup before process is spawned

   // base.reg otherwise directly before process is loaded
   // variant configuration is considered. If bProcEnabled is
   // false then registry is not loaded.

   tU32 u32StartTimeRel;
   tU32 u32StartTimeAbs;
};

typedef std::map < std::string, TProcConfiguration > TMapProcessConfiguration;
typedef std::map < std::string, std::string > TMapRegistries;

