/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IStartupSystemGroupServer.h
  * @brief        This is header file contains interface functions to add group and variable.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISpmBase.h"
// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

#define SPM_STARTUPGROUP_DEFAULT          "DEFAULT"
#define SPM_STARTUPGROUP_GROUPNAME        "GRP%02d"
#define SPM_STARTUPGROUP_GROUPNAME_LENGTH 7

// //////////////////////////////////////////////////////////////////////////////
// Interface to exchange the undervoltage/overvoltage information

/*!
  *  \class ISpmStartupSystemGroupServer
  *  \brief This abstract class provides interfaces to add group and variable.
          It also delivers pure virtual function to get group according to index value.
  */
class ISpmStartupSystemGroupServer : public ISpmBase
{
public:
ISpmStartupSystemGroupServer( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmStartupSystemGroupServer( ){
}

virtual tBool bIsGroup( const std::string& strPattern,
                        tU32             & u32ProcNb ) const       = 0;

// Add new group and return index to that group
virtual tS32 s32AddGroup( const std::string& strPattern )          = 0;

// add variables which are used in group order evaluation
virtual tVoid vAddVariable( const std::string& strName,
                            tU32               u32DatapoolOffset ) = 0;

virtual tVoid vStart( tU32 u32Index )                              = 0;

virtual tBool bHasNext( tU32 u32Index ) const                      = 0;

virtual tU32 u32GetSync( tU32 /* u32Index */ ){
   return( SPM_U32_SYNC_IGNORE );
}  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual std::string oGetNext( tU32 u32Index )           = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmStartupSystemGroupServer" ); }
virtual tBool find( tU32               u32Index,
                    const std::string& strProcessname ) = 0;

};

