/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IStartupInvestigationServer.h
  * @brief        This is header file contains interfaces to add start-up items and update application items and to set offset value of timer.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISpmBase.h"

struct spm_tclStartupItem
{
   std::string _name;
   std::string _context;

   spm_tclStartupItem( ){}
   spm_tclStartupItem( const spm_tclStartupItem& op ){
      _name    = op._name;
      _context = op._context;
   }

   private:
     //avoid assignment
     spm_tclStartupItem & operator = (const spm_tclStartupItem &corfoStartupItem);
};

#define SPM_STARTUPINVEST_INIT_STARTUPITEM               spm_tclStartupItem item;
#define SPM_STARTUPINVEST_INIT_TIME                      tU32 u32StartTimeInvest = 0;
#define SPM_STARTUPINVEST_SET_STARTTIME                  u32StartTimeInvest      = OSAL_ClockGetElapsedTime( );
#define SPM_STARTUPINVEST_CHECK_TIME_MEASURE( strName )        \
   { \
      tU32 u32Duration = OSAL_ClockGetElapsedTime( ) - u32StartTimeInvest; \
      if ( u32Duration > 20 ){ \
         item._context = "FACTORY"; \
         item._name    = strName; \
         _poclStartupInvest->vAddStartupItem( item ); \
      } \
   }
#define SPM_STARTUPINVEST_FORCE_ENTRY( strContext, strName )        \
   { \
      item._context = strContext; \
      item._name    = strName; \
      _poclStartupInvest->vAddStartupItem( item ); \
   }

// //////////////////////////////////////////////////////////////////////////////
// Interface to the startup investigation server

/*!
  *  \class ISpmStartupInvestigationServer
  *  \brief This abstract class provides interfaces to add startup items and update application items.
          It also delivers interfaces to set offset value of timer.
  */
class ISpmStartupInvestigationServer : public ISpmBase
{
public:
typedef enum
{
   SPM_STARTUP_APPLICATION_STARTREQ,
   SPM_STARTUP_APPLICATION_STARTCONF,
   SPM_STARTUP_APPLICATION_INITIALIZED,
   SPM_STARTUP_APPLICATION_STATEREQ,
   SPM_STARTUP_APPLICATION_STATECONF,
   SPM_SHUTDOWN_APPLICATION_STATEREQ,
   SPM_SHUTDOWN_APPLICATION_STATECONF

} tenSpmStartupReq;

ISpmStartupInvestigationServer( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmStartupInvestigationServer( ){}
virtual tVoid vStartupPerformed( )                                         = 0;

virtual tVoid vAddStartupItem( const spm_tclStartupItem& oStartupItem )    = 0;

virtual tVoid vUpdateApplicationItem( tU32             u32AppId,
                                      tenSpmStartupReq enReqState,
                                      tU32             u32RequestedState ) = 0;

virtual tVoid vTraceItems( )                                               = 0;

virtual tVoid vSetTimerOffset( tU32 u32TmrOffset )                         = 0;

virtual tVoid vDump( )                                                     = 0;

virtual tVoid vDumpShutdownInvestigation( )                                = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmStartupInvestigationServer" ); }
};

