/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_FITypes.h
  * @brief        fi relevant types and values. This list is generated.
  * @copyright    (C) 2013 - 2020 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once


// SPM_SUBSTATETYPE
#define SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS                   (tU32)0x00000000
#define SPM_U32_SUBSTATE_EMERGENCY_OFF                        (tU32)0x00000001
#define SPM_U32_SUBSTATE_FAST_SHUTDOWN                        (tU32)0x00000002
#define SPM_U32_SUBSTATE_DIMMING                              (tU32)0x00000003
#define SPM_U32_SUBSTATE_DOWNLOAD                             (tU32)0x00000004
#define SPM_U32_SUBSTATE_DIAG_ACTIVITY                        (tU32)0x00000005
#define SPM_U32_SUBSTATE_DIAGNOSIS                            (tU32)0x00000006
#define SPM_U32_SUBSTATE_PHONE                                (tU32)0x00000007
#define SPM_U32_SUBSTATE_S_CONTACT                            (tU32)0x00000008
#define SPM_U32_SUBSTATE_IGNITION                             (tU32)0x00000009
#define SPM_U32_SUBSTATE_TRANSPORTMODE                        (tU32)0x0000000a
#define SPM_U32_SUBSTATE_DOOROPEN                             (tU32)0x0000000b
#define SPM_U32_SUBSTATE_DOORLOCK                             (tU32)0x0000000c
#define SPM_U32_SUBSTATE_TRIGGER_FORCE_ON                     (tU32)0x0000000d
#define SPM_U32_SUBSTATE_CLIMATE_INFO                         (tU32)0x0000000e
#define SPM_U32_SUBSTATE_PARK_DISTANCE_CTRL                   (tU32)0x0000000f
#define SPM_U32_SUBSTATE_FACTORY_MODE                         (tU32)0x00000010
#define SPM_U32_SUBSTATE_CD_INSERT                            (tU32)0x00000011
#define SPM_U32_SUBSTATE_SD_INSERT                            (tU32)0x00000012
#define SPM_U32_SUBSTATE_EJECT                                (tU32)0x00000013
#define SPM_U32_SUBSTATE_ON_TIPPER                            (tU32)0x00000014
#define SPM_U32_SUBSTATE_SOFTTOP_OPEN                         (tU32)0x00000015
#define SPM_U32_SUBSTATE_AIRBAG_DEPLOYED                      (tU32)0x00000016
#define SPM_U32_SUBSTATE_KEY_PRESENT                          (tU32)0x00000017
#define SPM_U32_SUBSTATE_NETWORK_ACTIVITY                     (tU32)0x00000018
#define SPM_U32_SUBSTATE_OFF_TIPPER                           (tU32)0x00000019
#define SPM_U32_SUBSTATE_OFF_LASTSTATE_CYCLE                  (tU32)0x0000001a
#define SPM_U32_SUBSTATE_DIAG_REQUEST                         (tU32)0x0000001b
#define SPM_U32_SUBSTATE_BACKLIGHT                            (tU32)0x0000001c
#define SPM_U32_SUBSTATE_HIGH_VOLTAGE                         (tU32)0x0000001d
#define SPM_U32_SUBSTATE_RCV_CONNECTED                        (tU32)0x0000001e
#define SPM_U32_SUBSTATE_OFF_LEARN                            (tU32)0x0000001f
#define SPM_U32_SUBSTATE_HEARTBEAT                            (tU32)0x00000020
#define SPM_U32_SUBSTATE_USER_ON_REQ                          (tU32)0x00000021
#define SPM_U32_SUBSTATE_BACKGROUND_ON_REQ                    (tU32)0x00000022
#define SPM_U32_SUBSTATE_MULTIMEDIA_ON                        (tU32)0x00000023
#define SPM_U32_SUBSTATE_ANIMATION                            (tU32)0x00000024
#define SPM_U32_SUBSTATE_MULTIMEDIA_OPERATION                 (tU32)0x00000025
#define SPM_U32_SUBSTATE_TELEMATIC_ACTIVE                     (tU32)0x00000026
#define SPM_U32_SUBSTATE_STANDBY_REQ                          (tU32)0x00000027
#define SPM_U32_SUBSTATE_ACCESSORY_ACTIVE                     (tU32)0x00000028
#define SPM_U32_SUBSTATE_SHUTDOWN_BATTERY_SAVING              (tU32)0x00000029
#define SPM_U32_SUBSTATE_TML_REQ_BACKGROUND                   (tU32)0x0000002a
#define SPM_U32_SUBSTATE_IGNITION_TIMEOUT                     (tU32)0x0000002b
#define SPM_U32_SUBSTATE_IGNITION_INVALID                     (tU32)0x0000002c
#define SPM_U32_SUBSTATE_FIRST_PIC_DRAWN                      (tU32)0x0000002d
#define SPM_U32_SUBSTATE_OVERTEMP                             (tU32)0x0000002e
#define SPM_U32_SUBSTATE_LOCK_ACTIVITY                        (tU32)0x0000002f
#define SPM_U32_SUBSTATE_SYSSTATE_CHECK                       (tU32)0x00000030
#define SPM_U32_SUBSTATE_CR_TEMPERATURE                       (tU32)0x00000031
#define SPM_U32_SUBSTATE_PUSH_TO_TALK                         (tU32)0x00000032
#define SPM_U32_SUBSTATE_ROUTEGUIDANCE_ACTIVE                 (tU32)0x00000033
#define SPM_U32_SUBSTATE_HW_IGNITION                          (tU32)0x00000034
#define SPM_U32_SUBSTATE_CAN_WAKEUP                           (tU32)0x00000035
#define SPM_U32_SUBSTATE_DOWNLOAD_PERMISSION                  (tU32)0x00000036
#define SPM_U32_SUBSTATE_IGNITION_LOGIC                       (tU32)0x00000037
#define SPM_U32_SUBSTATE_LOW_VOLTAGE                          (tU32)0x00000038
#define SPM_U32_SUBSTATE_STATE_DEBOUNCE                       (tU32)0x00000039
#define SPM_U32_SUBSTATE_NETWORK_FAILURE                      (tU32)0x0000003a
#define SPM_U32_SUBSTATE_STATE_TO                             (tU32)0x0000003b
#define SPM_U32_SUBSTATE_DEBUG_WAKEUP                         (tU32)0x0000003c
#define SPM_U32_SUBSTATE_AUTOMATIC                            (tU32)0x0000003d
#define SPM_U32_SUBSTATE_CODE_REQUEST                         (tU32)0x0000003e
#define SPM_U32_SUBSTATE_SYNC_SHUTDOWN_ACK                    (tU32)0x0000003f
#define SPM_U32_SUBSTATE_FRIENDLY_USER                        (tU32)0x00000040
#define SPM_U32_SUBSTATE_NISSAN_CMF1                          (tU32)0x00000041
#define SPM_U32_SUBSTATE_PREPARE_SHUTDOWN                     (tU32)0x00000042
#define SPM_U32_SUBSTATE_SHUTDOWN                             (tU32)0x00000043
#define SPM_U32_SUBSTATE_HKEY_PRESSED                         (tU32)0x00000044
#define SPM_U32_SUBSTATE_CD_INSERT_CLAMPS                     (tU32)0x00000045
#define SPM_U32_SUBSTATE_CRITICAL_LOW_VOLTAGE                 (tU32)0x00000046
#define SPM_U32_SUBSTATE_ENDURING_LOW_VOLTAGE                 (tU32)0x00000047
#define SPM_U32_SUBSTATE_DIAG_FAST_SHUTDOWN                   (tU32)0x00000048
#define SPM_U32_SUBSTATE_USING_ACCESSORY                      (tU32)0x00000049
#define SPM_U32_SUBSTATE_BACKGROUND_IMM_OFF                   (tU32)0x0000004a
#define SPM_U32_SUBSTATE_ROLLER_RIG_MODE                      (tU32)0x0000004b
#define SPM_U32_SUBSTATE_REMOTE_ON_ACTIVE                     (tU32)0x0000004c
#define SPM_U32_SUBSTATE_ENDURING_CR_VOLTAGE                  (tU32)0x0000004d
#define SPM_U32_SUBSTATE_NORMAL_VOLT                          (tU32)0x0000004e
#define SPM_U32_SUBSTATE_Q_CRITICAL                           (tU32)0x0000004f
#define SPM_U32_SUBSTATE_TRIGGER_RESET                        (tU32)0x00000050
#define SPM_U32_SUBSTATE_CAR_WAKEUP                           (tU32)0x00000051
#define SPM_U32_SUBSTATE_PHONE_CONNECTED                      (tU32)0x00000052
#define SPM_U32_SUBSTATE_CUSTOMER_DOWNLOAD                    (tU32)0x00000053
#define SPM_U32_SUBSTATE_STARTUP                              (tU32)0x00000054
#define SPM_U32_SUBSTATE_MOST_OFF                             (tU32)0x00000055
#define SPM_U32_SUBSTATE_MOST_OFF_ERR                         (tU32)0x00000056
#define SPM_U32_SUBSTATE_MOST_WAIT_FOR_SHUTDOWN               (tU32)0x00000057
#define SPM_U32_SUBSTATE_MOST_RBD                             (tU32)0x00000058
#define SPM_U32_SUBSTATE_MOST_SHUTDOWN_EXECUTE                (tU32)0x00000059
#define SPM_U32_SUBSTATE_MOST_PWR_SWITCH_OFF_DELAY            (tU32)0x0000005a
#define SPM_U32_SUBSTATE_SYSSTATE_NETWORK_FAILED              (tU32)0x0000005b
#define SPM_U32_SUBSTATE_SAFE                                 (tU32)0x0000005c
#define SPM_U32_SUBSTATE_FSM_SHUTDOWN_FINISHED                (tU32)0x0000005d
#define SPM_U32_SUBSTATE_WAIT_FOR_FSM_SHUTDOWN_ACK            (tU32)0x0000005e
#define SPM_U32_SUBSTATE_WAIT_FOR_FSM_RESTART_ACK             (tU32)0x0000005f
#define SPM_U32_SUBSTATE_VALET_MODE                           (tU32)0x00000060
#define SPM_U32_SUBSTATE_CRANK                                (tU32)0x00000061
#define SPM_U32_SUBSTATE_EMERGENCY_CALL                       (tU32)0x00000062
#define SPM_U32_SUBSTATE_LIN                                  (tU32)0x00000063
#define SPM_U32_SUBSTATE_CELLNETWORK                          (tU32)0x00000064
#define SPM_U32_SUBSTATE_EXTERNAL_GPIO                        (tU32)0x00000065
#define SPM_U32_SUBSTATE_BLUETOOTH                            (tU32)0x00000066
#define SPM_U32_SUBSTATE_UART                                 (tU32)0x00000067
#define SPM_U32_SUBSTATE_USB                                  (tU32)0x00000068
#define SPM_U32_SUBSTATE_CRITICAL_HIGH_VOLTAGE                (tU32)0x00000069
#define SPM_U32_SUBSTATE_ENDURING_HIGH_VOLTAGE                (tU32)0x0000006a
#define SPM_U32_SUBSTATE_OVER_THE_AIR_ACTIVE                  (tU32)0x0000006b
#define SPM_U32_SUBSTATE_ENGINE_RUNNING                       (tU32)0x0000006c
#define SPM_U32_SUBSTATE_UNBALLAST_SWITCH_OFF                 (tU32)0x0000006d
#define SPM_U32_SUBSTATE_CUSTOMER_FEEDBACK_NEEDED             (tU32)0x0000006e
#define SPM_U32_SUBSTATE_SWITCH_OFF_REQUEST                   (tU32)0x0000006f
#define SPM_U32_SUBSTATE_DARK_SCREEN_REQ                      (tU32)0x00000070
#define SPM_U32_SUBSTATE_DISPLAY_REQUEST                      (tU32)0x00000071
#define SPM_U32_SUBSTATE_TOUCH_ACTIVITY                       (tU32)0x00000072
#define SPM_U32_SUBSTATE_STORAGE_MODE                         (tU32)0x00000073
#define SPM_U32_SUBSTATE_ECO_MODE                             (tU32)0x00000074
#define SPM_U32_SUBSTATE_ECO_MODE_TIMEOUT                     (tU32)0x00000075
#define SPM_U32_SUBSTATE_PHONE_ECO_MODE_TIMEOUT               (tU32)0x00000076
#define SPM_U32_SUBSTATE_PHONE_ECO_MODE_POPUP_TIMEOUT         (tU32)0x00000077
#define SPM_U32_SUBSTATE_EXTERNAL_SHUTDOWN_REQ                (tU32)0x00000078
#define SPM_U32_SUBSTATE_EXTERNAL_SHUTDOWN_CONFIG             (tU32)0x00000079
#define SPM_U32_SUBSTATE_DEMAND_AUDIO_MUTE                    (tU32)0x0000007a
#define SPM_U32_SUBSTATE_PERTE_COM                            (tU32)0x0000007b
#define SPM_U32_SUBSTATE_SHUTDOWN_SCREEN_TIMEOUT              (tU32)0x0000007c
#define SPM_U32_SUBSTATE_OFF_REQUEST                          (tU32)0x0000007d
#define SPM_U32_SUBSTATE_ALERT_MODE                           (tU32)0x0000007e
#define SPM_U32_SUBSTATE_ECO_MODE_ACTIVATED                   (tU32)0x0000007f
#define SPM_U32_SUBSTATE_SMARTAPP_COMM                        (tU32)0x00000080
#define SPM_U32_SUBSTATE_PHONE_MUTE                           (tU32)0x00000081
#define SPM_U32_SUBSTATE_WAITING                              (tU32)0x00000082
#define SPM_U32_SUBSTATE_MAPLEARN_ONGOING                     (tU32)0x00000083
#define SPM_U32_SUBSTATE_SPI_PHONE                            (tU32)0x00000084
#define SPM_U32_SUBSTATE_DMVERITY_CHECK                       (tU32)0x00000085

// SPM_ONOFFREASON
#define SPM_SUBSTATE_TIPPER_ON                            (tU32)0x00000001
#define SPM_SUBSTATE_DIAG                                 (tU32)0x00000002
#define SPM_SUBSTATE_DOWNLOAD                             (tU32)0x00000004
#define SPM_SUBSTATE_TRANSPORT_MODE                       (tU32)0x00000008
#define SPM_SUBSTATE_IGNITION                             (tU32)0x00000010
#define SPM_SUBSTATE_S_CONTACT                            (tU32)0x00000020
#define SPM_SUBSTATE_DIAGNOSTICS_ACTIVITY                 (tU32)0x00000040
#define SPM_SUBSTATE_PHONE                                (tU32)0x00000080
#define SPM_SUBSTATE_NETWORK_ACTIVITY                     (tU32)0x00000100
#define SPM_SUBSTATE_CD_INSERT                            (tU32)0x00000200
#define SPM_SUBSTATE_DIM                                  (tU32)0x00000400
#define SPM_SUBSTATE_CAN_BUS_WAKEUP                       (tU32)0x00000800
#define SPM_SUBSTATE_DOWNLOAD_PERMISSION                  (tU32)0x00001000
#define SPM_SUBSTATE_EJECT_KEY_DETECTED                   (tU32)0x00002000
#define SPM_SUBSTATE_DRIVER_DOOR                          (tU32)0x00004000
#define SPM_SUBSTATE_UNDER_VOLTAGE                        (tU32)0x00008000
#define SPM_SUBSTATE_EMERGENCY_OFF                        (tU32)0x00010000
#define SPM_SUBSTATE_1H_LOGIC_TIMEOUT                     (tU32)0x00020000
#define SPM_SUBSTATE_FAST_SHUTDOWN                        (tU32)0x00100000
#define SPM_SUBSTATE_HW_IGNITION                          (tU32)0x00200000
#define SPM_SUBSTATE_PHONE_MUTE                           (tU32)0x00400000
#define SPM_SUBSTATE_MAUS_ACTIVITY                        (tU32)0x00800000
#define SPM_SUBSTATE_PUSH_TO_TALK                         (tU32)0x02000000
#define SPM_SUBSTATE_CR_TEMPERATURE                       (tU32)0x04000000
#define SPM_SUBSTATE_NETWORK_FAILURE                      (tU32)0x08000000
#define SPM_SUBSTATE_SAFE                                 (tU32)0x10000000

// SPM_SYSTEM_STATES
#define SPM_SYSTEM_BACKGROUND                             0x00000005
#define SPM_SYSTEM_PREPARE_SHUTDOWN                       0x00000010
#define SPM_SYSTEM_SHUTDOWN                               0x00000011
#define SPM_SYSTEM_SUSPEND                                0x00000000
#define SPM_SYSTEM_STANDBY                                0x00000001
#define SPM_SYSTEM_OFF                                    0x00000002
#define SPM_SYSTEM_DOWNLOAD                               0x00000003
#define SPM_SYSTEM_ON                                     0x00000004
#define SPM_SYSTEM_DOOR_OPEN                              0x00000006
#define SPM_SYSTEM_IGNITION                               0x00000007
#define SPM_SYSTEM_DIAGNOSIS                              0x00000008
#define SPM_SYSTEM_STATE_PROFILE                          0x00000009
#define SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1                 0x00000020
#define SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2                 0x00000021
#define SPM_SYSTEM_MMI_STANDBY                            0x00000022
#define SPM_SYSTEM_MMI_ON                                 0x00000023
#define SPM_SYSTEM_MMI_STANDBY_RESTRICTED                 0x00000024
#define SPM_SYSTEM_MMI_ON_DIAG                            0x00000025
#define SPM_SYSTEM_MMI_ON_TEL                             0x00000026
#define SPM_SYSTEM_MMI_ON_SWDL                            0x00000027
#define SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL              0x00000028
#define SPM_SYSTEM_MMI_STANDBY_PWR_SAVE                   0x00000029
#define SPM_SYSTEM_OVERTEMP                               0x0000002a
#define SPM_SYSTEM_SAFE                                   0x0000002b
#define SPM_SYSTEM_STATE_MAX                              0x0000002c

// SPM_SYSPWR_BEHAVIOUR
#define SPM_SYSPWR_NORMAL                                 0x00000000
#define SPM_SYSPWR_BATTERY_LOW_SHUTDOWN                   0x00000001
#define SPM_SYSPWR_BATTERY_LOW_WARNING                    0x00000002
#define SPM_SYSPWR_PHONE_HANDOVER_WARN                    0x00000003

// SPM_HMI_STATE
#define SPM_HMISTATE_SHOW_OFF                             0x00000001
#define SPM_HMISTATE_SHOW_HMI                             0x00000002
#define SPM_HMISTATE_SHOW_CLOCK                           0x00000003
#define SPM_HMISTATE_SHOW_GOODBYE                         0x00000004
#define SPM_HMISTATE_SHOW_PHONE                           0x00000005
#define SPM_HMISTATE_SHOW_CLIMATE_CLOCK                   0x00000006
#define SPM_HMISTATE_SHOW_HMI_HOUR_MODE                   0x00000007
#define SPM_HMISTATE_ANIMATION                            0x00000008
#define SPM_HMISTATE_SHOW_ON_INFO_WARN                    0x00000009
#define SPM_HMISTATE_SHOW_OFF_PHONE                       0x0000000a
#define SPM_HMISTATE_SHOW_OFF_OPS                         0x0000000b
#define SPM_HMISTATE_SHOW_OFF_CLIMATE                     0x0000000c
#define SPM_HMISTATE_SHOW_ON_INFO_OFF                     0x0000000d
#define SPM_HMISTATE_SHOW_OFF_DIAG                        0x0000000e
#define SPM_HMISTATE_SHOW_INFOTAINMENT_OFF                0x0000000f
#define SPM_HMISTATE_SHOW_CLOCK_OVERTEMP                  0x00000010
#define SPM_HMISTATE_SHOW_CLIMATE_CLOCK_OVERTEMP          0x00000011
#define SPM_HMISTATE_SECURE_GREEN                         0x00000012
#define SPM_HMISTATE_SECURE_YELLOW                        0x00000013
#define SPM_HMISTATE_SECURE_RED                           0x00000014
#define SPM_HMISTATE_SECURE_WAIT                          0x00000015
#define SPM_HMISTATE_SLEEP_SCREEN                         0x00000016
#define SPM_HMISTATE_SLEEP                                0x00000017
#define SPM_HMISTATE_COMM_ENABLED                         0x00000018
#define SPM_HMISTATE_INACTIVE                             0x00000019
#define SPM_HMISTATE_FULL_OPERATION                       0x0000001a
#define SPM_HMISTATE_THEFTLOCKED                          0x0000001b
#define SPM_HMISTATE_NO_CALIBRATION                       0x0000001c
#define SPM_HMISTATE_NOVIN_MODE                           0x0000001d
#define SPM_HMISTATE_VALET_MODE                           0x0000001e
#define SPM_HMISTATE_LOCAL_PHONE                          0x0000001f
#define SPM_HMISTATE_LOCAL_INFORMATION                    0x00000020
#define SPM_HMISTATE_LOCAL_EJECT                          0x00000021
#define SPM_HMISTATE_LOCAL_INFOTAINMENT                   0x00000022
#define SPM_HMISTATE_CRANK                                0x00000023
#define SPM_HMISTATE_REMOTE_PROGRAMMING                   0x00000024
#define SPM_HMISTATE_SEAT_BELT_RESTRICTIONS               0x00000025
#define SPM_HMISTATE_SHOW_BATTERY_SAVER                   0x00000026
#define SPM_HMISTATE_LOCAL_VALET                          0x00000027
#define SPM_HMISTATE_SYSTEM_INIT                          0x00000028
#define SPM_HMISTATE_STARTUP_ANIMATION                    0x00000029
#define SPM_HMISTATE_SHOW_OVERTEMPERATURE                 0x0000002a
#define SPM_HMISTATE_SHOW_STANDBY_RESTRICTED              0x0000002b
#define SPM_HMISTATE_SHOW_STANDBY                         0x0000002c
#define SPM_HMISTATE_SHOW_ON_PARTIAL_STANDBY              0x0000002d
#define SPM_HMISTATE_SHOW_ON_PARTIAL_USER                 0x0000002e
#define SPM_HMISTATE_SHOW_ON_PARTIAL_DARK                 0x0000002f
#define SPM_HMISTATE_SHOW_ON_FULL_STANDBY                 0x00000030
#define SPM_HMISTATE_SHOW_ON_FULL_DARK                    0x00000031

// SPM_DIM_STATE
#define SPM_DIMSTATE                                      0x00000001
#define SPM_DIMSTATE_CLIMATE                              0x00000002
#define SPM_DIMSTATE_BACKLIGHT                            0x00000004
#define SPM_DIMSTATE_HOUR_MODE                            0x00000008
#define SPM_DIMSTATE_ALL_OFF                              0x00000010
#define SPM_DIMSTATE_TLIN_ON_BACKLIGHT_OFF                0x00000020
#define SPM_DIMSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED         0x00000040
#define SPM_DIMSTATE_ALL_ON                               0x00000080

// SPM_BT_STATE
#define SPM_BLUETOOTHSTATE_BT_OFF                         0x00000000
#define SPM_BLUETOOTHSTATE_BLOCK                          0x00000001
#define SPM_BLUETOOTHSTATE_VALET_MODE                     0x00000002
#define SPM_BLUETOOTHSTATE_DISCONNECT                     0x00000003
#define SPM_BLUETOOTHSTATE_NO_ACTION                      0x00000004
#define SPM_BLUETOOTHSTATE_NORMAL                         0x00000005
#define SPM_BLUETOOTHSTATE_NORMAL_SWITCH_OFF_BT           0x00000006

// SPM_WIFI_STATE
#define SPM_WIFISTATE_OFF                                 0x00000000
#define SPM_WIFISTATE_BLOCK                               0x00000001
#define SPM_WIFISTATE_NORMAL                              0x00000002
#define SPM_WIFISTATE_NORMAL_SWITCH_OFF_WIFI              0x00000003

// SPM_AUDIO_STATE
#define SPM_AUDIOSTATE_OFF                                0x00000000
#define SPM_AUDIOSTATE_EMERGENCY                          0x00000001
#define SPM_AUDIOSTATE_NORMAL                             0x00000002
#define SPM_AUDIOSTATE_LIMITED                            0x00000003

// SPM_SPI_STATE
#define SPM_SPISTATE_OFF                                  0x00000000
#define SPM_SPISTATE_ON                                   0x00000001

// SPM_TUNER_STATE
#define SPM_TUNER_OFF                                     0x00000000
#define SPM_TUNER_ON                                      0x00000001
#define SPM_TUNER_LANDSCAPE_SCAN                          0x00000002

// SPM_AUDIO_SOURCE
#define SPM_AUDIOSRC_NONE                                 0x00000000
#define SPM_AUDIOSRC_RADIO_FM1                            0x00000001
#define SPM_AUDIOSRC_RADIO_FM2                            0x00000002
#define SPM_AUDIOSRC_RADIO_AM                             0x00000003
#define SPM_AUDIOSRC_RADIO_DAB                            0x00000004
#define SPM_AUDIOSRC_MEDIA_CDCOMP                         0x00000005
#define SPM_AUDIOSRC_MEDIA_SD                             0x00000006
#define SPM_AUDIOSRC_MEDIA_BTAUDIO                        0x00000007
#define SPM_AUDIOSRC_MEDIA_MDI                            0x0000000a
#define SPM_AUDIOSRC_MEDIA_AUXPLATE                       0x0000000c
#define SPM_AUDIOSRC_RADIO_TA                             0x0000000d
#define SPM_AUDIOSRC_NAVISPEECH                           0x0000000e
#define SPM_AUDIOSRC_TELEPHONE                            0x0000000f
#define SPM_AUDIOSRC_TELEPHONE_MUTE                       0x00000010
#define SPM_AUDIOSRC_OPS_PDC                              0x00000013
#define SPM_AUDIOSRC_MEDIA_CDDA                           0x00000014
#define SPM_AUDIOSRC_MEDIA_CDC                            0x00000015
#define SPM_AUDIOSRC_ENTERTAINMENT_MUTE                   0x00000016
#define SPM_AUDIOSRC_DIAGNOSIS_MUTE                       0x00000017
#define SPM_AUDIOSRC_SYSTEM_MUTE                          0x00000018
#define SPM_AUDIOSRC_CLUSTER_MUTE                         0x00000019
#define SPM_AUDIOSRC_PIN_MUTE                             0x0000001a
#define SPM_AUDIOSRC_LIMITED_SYSTEM_MUTE                  0x0000001b
#define SPM_AUDIOSRC_MEDIA_IPOD                           0x0000001c
#define SPM_AUDIOSRC_MEDIA_USB                            0x0000001d
#define SPM_AUDIOSRC_RADIO_XM                             0x0000001e
#define SPM_AUDIOSRC_NAVIINFO                             0x0000001f
#define SPM_AUDIOSRC_AUDIO_OFF_MUTE                       0x00000020
#define SPM_AUDIOSRC_SDS                                  0x00000021
#define SPM_AUDIOSRC_DOV                                  0x00000022
#define SPM_AUDIOSRC_DOV_TEST                             0x00000023
#define SPM_AUDIOSRC_MEDIA_PANODRA                        0x00000024
#define SPM_AUDIOSRC_SDS_SMS                              0x00000025
#define SPM_AUDIOSRC_RADIO_DAB_TA                         0x00000026
#define SPM_AUDIOSRC_RADIO_DABSERVICEFOLLOWING            0x00000027
#define SPM_AUDIOSRC_SPI_BT_AUDIO                         0x00000028
#define SPM_AUDIOSRC_SPI_USB                              0x00000029
#define SPM_AUDIOSRC_SPI_VR_USB                           0x0000002a
#define SPM_AUDIOSRC_SPI_VR_BT_AUDIO                      0x0000002b
#define SPM_AUDIOSRC_SPI_TTS                              0x0000002c
#define SPM_AUDIOSRC_MEDIA_DB_PLAYER                      0x0000002d
#define SPM_AUDIOSRC_CUE                                  0x0000002e
#define SPM_AUDIOSRC_VOLTAGE_MUTE                         0x0000002f
#define SPM_AUDIOSRC_AUD_DEV__NOT_AVAIL                   0x00000030
#define SPM_AUDIOSRC_MIC_LOOPBACK                         0x00000031
#define SPM_AUDIOSRC_IPA_MUTE                             0x00000032

// SPM_CD_INSERT_STATE
#define SPM_CD_INSERT_INACTIVE                            0x00000000
#define SPM_CD_INSERT_ACTIVE                              0x00000001

// SPM_SYS_STATE
#define SPM_SYSSTATE_SLEEP                                0x00000000
#define SPM_SYSSTATE_COMM_ENABLED                         0x00000001
#define SPM_SYSSTATE_INACTIVE                             0x00000002
#define SPM_SYSSTATE_FULL_OPERATION                       0x00000003
#define SPM_SYSSTATE_THEFTLOCKED                          0x00000004
#define SPM_SYSSTATE_NO_CALIBRATION                       0x00000005
#define SPM_SYSSTATE_NOVIN_MODE                           0x00000006
#define SPM_SYSSTATE_VALET_MODE                           0x00000007
#define SPM_SYSSTATE_LOCAL_PHONE                          0x00000008
#define SPM_SYSSTATE_LOCAL_INFORMATION                    0x00000009
#define SPM_SYSSTATE_LOCAL_EJECT                          0x0000000a
#define SPM_SYSSTATE_LOCAL_INFOTAINMENT                   0x0000000b
#define SPM_SYSSTATE_CRANK                                0x0000000c
#define SPM_SYSSTATE_REMOTE_PROGRAMMING                   0x0000000d
#define SPM_SYSSTATE_SEAT_BELT_RESTRICTIONS               0x0000000e
#define SPM_SYSSTATE_SHOW_BATTERY_SAVER                   0x0000000f
#define SPM_SYSSTATE_LOCAL_VALET                          0x00000010
#define SPM_SYSSTATE_SYSTEM_INIT                          0x00000011
#define SPM_SYSSTATE_STARTUP_ANIMATION                    0x00000012
#define SPM_SYSSTATE_SHOW_OFF                             0x00000080

// SPM_MOST_EVENT
#define SPM_MOST_EVENT_NO_EVENT                           0x00000000
#define SPM_MOST_EVENT_NET_ON                             0x00000001
#define SPM_MOST_EVENT_NET_OFF                            0x00000002
#define SPM_MOST_EVENT_UNLOCK                             0x00000003
#define SPM_MOST_EVENT_LOCK_STABLE                        0x00000004
#define SPM_MOST_EVENT_SHUTDOWN_EXECUTE                   0x00000005
#define SPM_MOST_EVENT_CONFIG_STATE                       0x00000006
#define SPM_MOST_EVENT_RING_OFF                           0x00000007
#define SPM_MOST_EVENT_RING_ON                            0x00000008
#define SPM_MOST_EVENT_TLA_STATE                          0x00000009

// SPM_MOST_CONFIG_STATE
#define SPM_MOST_CONFIG_STATE_UNAVAILABLE                 0x00000000
#define SPM_MOST_CONFIG_STATE_NOT_OK                      0x00000001
#define SPM_MOST_CONFIG_STATE_OK                          0x00000002
#define SPM_MOST_CONFIG_STATE_INVALID                     0x00000003
#define SPM_MOST_CONFIG_STATE_NEW                         0x00000004
#define SPM_MOST_CONFIG_STATE_NEW_EXT                     0x00000005

// SPM_TLA_STATE
#define SPM_TLA_STATE_UNAVAILABLE                         0x00000000
#define SPM_TLA_STATE_DISCONNECTED                        0x00000001
#define SPM_TLA_STATE_CONNECTED                           0x00000002

// SPM_PROCESSOR_STATE
#define SPM_PROC_STATE_NORMAL                             0x00000000
#define SPM_PROC_STATE_DNL                                0x00000001
#define SPM_PROC_STATE_TM                                 0x00000002
#define SPM_PROC_STATE_STANDBY                            0x00000003
#define SPM_PROC_STATE_DOWN                               0x000000ff

// SPM_STARTUP_STATE
#define SPM_STARTUP_STATE_INIT                            0x00000000
#define SPM_STARTUP_STATE_BASE                            0x00000001
#define SPM_STARTUP_STATE_VD                              0x00000002
#define SPM_STARTUP_STATE_FC                              0x00000004
#define SPM_STARTUP_STATE_NAVI                            0x00000008
#define SPM_STARTUP_STATE_SDS                             0x00000010
#define SPM_STARTUP_STATE_HMI                             0x00000020
#define SPM_STARTUP_STATE_MM                              0x00000040
#define SPM_STARTUP_STATE_MAP                             0x00000080
#define SPM_STARTUP_STATE_TUNER                           0x00000100

// SPM_RESTART_TYPE
#define SPM_RESTART_ECU                                   0x00000000
#define SPM_RESTART_WDT                                   0x00000001
#define SPM_RESTART_ECU_FAST                              0x00000002
#define SPM_RESTART_DOWNLOAD_ERROR                        0x00000003
#define SPM_RESTART_DOWNLOAD_FINISHED                     0x00000004
#define SPM_RESTART_ECU_WITH_SYNC                         0x00000005
#define SPM_RESTART_DOWNLOAD_ABORTED                      0x00000006
#define SPM_RESTART_ECU_ALTSW_TESTMANAGER                 0x00000007
#define SPM_SYNC_WITHOUT_RESTART                          0x00000008
#define SPM_RESTART_APP                                   0x00000009
#define SPM_RESTART_APP_FAST                              0x0000000a
#define SPM_RESTART_APP_WITH_SYNC                         0x0000000b
#define SPM_RESTART_SCC                                   0x0000000c
#define SPM_RESTART_USER_RESET                            0x0000000d

// SPM_CODE_REQUEST
#define SPM_CODE_IDLE                                     0x00000000
#define SPM_CODE_REQUESTED                                0x00000001
#define SPM_CODE_PROCESSED                                0x00000002

// SPM_WAKEUP_REASON
#define SPM_WAKEUP_INVALID                                0x00000000
#define SPM_WAKEUP_CAN                                    0x00000001
#define SPM_WAKEUP_EJECT                                  0x00000002
#define SPM_WAKEUP_INSERT                                 0x00000003
#define SPM_WAKEUP_IGNITION                               0x00000004
#define SPM_WAKEUP_RTC                                    0x00000005
#define SPM_WAKEUP_POWER_ON                               0x00000006
#define SPM_WAKEUP_ON_TIPPER                              0x00000007
#define SPM_WAKEUP_MOST                                   0x00000008
#define SPM_WAKEUP_DEBUG_WAKEUP                           0x00000009
#define SPM_WAKEUP_DOOR_OPEN                              0x0000000a
#define SPM_SDCARD_INSERT                                 0x0000000b
#define SPM_WAKEUP_PHONE_MUTE                             0x0000000c
#define SPM_WAKEUP_ACCESSORY                              0x0000000d
#define SPM_WAKEUP_CELLNETWORK                            0x0000000e
#define SPM_WAKEUP_CAN2                                   0x0000000f
#define SPM_WAKEUP_CAN3                                   0x00000010
#define SPM_WAKEUP_CAN4                                   0x00000011
#define SPM_WAKEUP_ODOMETER                               0x00000012
#define SPM_WAKEUP_LIN                                    0x00000013
#define SPM_WAKEUP_ACCELLERATOR_SENSOR                    0x00000014
#define SPM_WAKEUP_EXTERNAL_GPIO                          0x00000015
#define SPM_WAKEUP_EXTERNAL_GPIO2                         0x00000016
#define SPM_WAKEUP_EXTERNAL_GPIO3                         0x00000017
#define SPM_WAKEUP_EXTERNAL_GPIO4                         0x00000018
#define SPM_WAKEUP_BLUETOOTH                              0x00000019
#define SPM_WAKEUP_USB                                    0x0000001a
#define SPM_WAKEUP_UART                                   0x0000001b
#define SPM_WAKEUP_UART2                                  0x0000001c
#define SPM_WAKEUP_ILLUMINATION                           0x0000001d
#define SPM_WAKEUP_RESET                                  0x000000ff
#define SPM_WAKEUP_RESTART                                0xffffffff

// SPM_MEDIA_EJECT_STATE
#define SPM_EJECT_RELEASED                                0x00000000
#define SPM_EJECT_PRESSED                                 0x00000002

// SPM_KEY_STATE
#define SPM_RELEASED                                      0x00000000
#define SPM_PRESSED                                       0x00000001

// SPM_SECURITY_STATE
#define SPM_SECURITY_STATE_NO_VIN                         0x00000000
#define SPM_SECURITY_STATE_HAS_VIN                        0x00000001
#define SPM_SECURITY_STATE_THEFT_PROTECTED                0x00000002

// SPM_STARTUP_REASON
#define SPM_STARTUP_ON_EJECT                              0x00000001
#define SPM_STARTUP_ON_INSERT                             0x00000002

// SPM_PHONE_MUTE_STATE
#define SPM_PHONEMUTE_INACTIVE                            0x00000000
#define SPM_PHONEMUTE_ACTIVE                              0x00000001

// SPM_RESETREASON
#define SPM_EHMI_COPRO_NO_REASON                          0x00000000
#define SPM_EHMI_COPRO_SPI_ERROR                          0x00000001
#define SPM_EHMI_COPRO_WATCHDOG_TIMEOUT                   0x00000002
#define SPM_EHMI_COPRO_SMACK_TIMEOUT                      0x00000003
#define SPM_EHMI_COPRO_RSTOUT_INACTIVE                    0x00000004
#define SPM_EHMI_COPRO_RSTOUT_ACTIVE_TIMEOUT              0x00000005
#define SPM_EHMI_COPRO_RSTOUT_INACTIVE_TIMEOUT            0x00000006
#define SPM_EHMI_COPRO_WAKEUP_MSG_TIMEOUT                 0x00000007
#define SPM_EHMI_COPRO_NO_MODE_TIMEOUT                    0x00000008
#define SPM_EHMI_APP_NOT_INITIALIZED                      0x00000009
#define SPM_EHMI_APP_NOT_ACK                              0x0000000a
#define SPM_EHMI_APP_END_WANTED                           0x0000000b
#define SPM_EHMI_APP_WDT_ERROR                            0x0000000c
#define SPM_EHMI_APP_NOTIFY_ERROR                         0x0000000d
#define SPM_EHMI_APP_DOWNLOAD_ERROR                       0x0000000e
#define SPM_EHMI_APP_DOWNLOAD                             0x0000000f
#define SPM_EHMI_WDT                                      0x00000010
#define SPM_EHMI_MPU_WDT                                  0x00000011
#define SPM_EHMI_DSP_WDT                                  0x00000012
#define SPM_EHMI_RST_SOFTWARE                             0x00000013
#define SPM_EHMI_MPU                                      0x00000014
#define SPM_EHMI_RST_UNKNOWN                              0x00000015
#define SPM_EHMI_EXTERN                                   0x00000016
#define SPM_EHMI_RST_USER                                 0x00000017
#define SPM_ERU_UNKNOWN                                   0x00000018
#define SPM_ERU_UNDERVOLTAGE                              0x00000019
#define SPM_ERU_HMI                                       0x0000001a
#define SPM_EFGS_HMI                                      0x0000001b
#define SPM_EFGS_FGS                                      0x0000001c
#define SPM_EHMI_RST_OVERTEMPERATURE                      0x0000001d
#define SPM_EHMI_SLV_SUPERVISION                          0x0000001e
#define SPM_EHMI_RST_ECU                                  0x0000001f
#define SPM_EHMI_ECU_FAST                                 0x00000020
#define SPM_EHMI_APP_WDT_HEARTBEAT_ERROR                  0x00000021
#define SPM_EHMI_SLV_PROCESS_SUPERVISION                  0x00000022
#define SPM_EHMI_SLV_REQUESTED_RESET                      0x00000023
#define SPM_EHMI_RST_POWER_ON_RESET                       0x00000024

// SPM_LCMRESETREASON
#define SPM_EHMI_APP_ERROR                                0x00000000
#define SPM_EHMI_ECU                                      0x00000001
#define SPM_EHMI_USER                                     0x00000002
#define SPM_EHMI_DOWNLOAD                                 0x00000003
#define SPM_EHMI_DOWNLOAD_ERROR                           0x00000004
#define SPM_EHMI_SOFTWARE                                 0x00000005
#define SPM_EHMI_UNKNOWN                                  0x00000006
#define SPM_EHMI_OVERTEMPERATURE                          0x00000007
#define SPM_EHMI_LCM_INTERN                               0x00000008
#define SPM_EHMI_POWER_ON_RESET                           0x0000003c
#define SPM_EHMI_POWER_LOSS                               0x0000003d
#define SPM_EHMI_POWER_OFF                                0x0000003e
#define SPM_EHMI_SCC                                      0x0000003f
#define SPM_EHMI_WARMSTART                                0x00000063
#define SPM_ESCC_HW_WATCHDOG                              0x00000064
#define SPM_ESCC_POWER_ON                                 0x00000065
#define SPM_ESCC_COLDSTART                                0x00000066
#define SPM_ESCC_APPMODE_CHANGE                           0x00000067
#define SPM_ESCC_DURING_LPW                               0x00000068
#define SPM_ESCC_DURING_PLL_OSZ                           0x00000069
#define SPM_ESCC_DURING_SW                                0x0000006a
#define SPM_ESCC_WARMSTART                                0x0000006b
#define SPM_ESCC_USER                                     0x0000006c

// SPM_CVM_EVENT
#define SPM_CVM_CRITICAL_LOW_VOLTAGE_START                0x00000000
#define SPM_CVM_CRITICAL_LOW_VOLTAGE_END                  0x00000001
#define SPM_CVM_LOW_VOLTAGE_START                         0x00000002
#define SPM_CVM_LOW_VOLTAGE_END                           0x00000003
#define SPM_CVM_HIGH_VOLTAGE_START                        0x00000004
#define SPM_CVM_HIGH_VOLTAGE_END                          0x00000005
#define SPM_CVM_CRITICAL_HIGH_VOLTAGE_START               0x00000006
#define SPM_CVM_CRITICAL_HIGH_VOLTAGE_END                 0x00000007
#define SPM_CVM_NO_EVENT                                  0x0000000f

// SPM_SYSPWRMODE
#define SPM_SYSPWRMODE_UNDEFINED                          0x00000000
#define SPM_SYSPWRMODE_OFF                                0x00000001
#define SPM_SYSPWRMODE_ACCESSORY                          0x00000002
#define SPM_SYSPWRMODE_RUN                                0x00000003
#define SPM_SYSPWRMODE_CRANK                              0x00000004

// SPM_STATEMODES
#define SPM_E8_SYSMODEDOWNLOAD                            0x00000000
#define SPM_E8_SYSMODEDIAG                                0x00000001
#define SPM_E8_SYSMODEDOWNLOADEXIT                        0x00000002
#define SPM_E8_SYSMODECUSTOMERDOWNLOADSTART               0x00000003
#define SPM_E8_SYSMODECUSTOMERDOWNLOADEXIT                0x00000004
#define SPM_E8_SYSMODEDIAGACTIVITYSTART                   0x00000005
#define SPM_E8_SYSMODEDIAGACTIVITYEXIT                    0x00000006
#define SPM_E8_SYSMODEDIAGEXIT                            0x00000007
#define SPM_E8_SYSMODEMAPDOWNLOADLOCK                     0x00000008
#define SPM_E8_SYSMODEMAPDOWNLOADUNLOCK                   0x00000009
#define SPM_E8_SYSMODEMAPDOWNLOADMASTERUNLOCK             0x0000000a

// SPM_STATEENTRYTYPE
#define SPM_E8_HISTORYENTRYWAKEUP                         0x00000000
#define SPM_E8_HISTORYENTRYSUBSTATE                       0x00000001
#define SPM_E8_HISTORYENTRYRESET                          0x00000002

// SPM_DOWNLOADLOCKSTATES
#define SPM_E8_DOWNLOADLOCK                               0x00000000
#define SPM_E8_DOWNLOADUNLOCK                             0x00000001
#define SPM_E8_DOWNLOADMASTERUNLOCK                       0x00000002

// SPM_PROCESSSTATE
#define SPM_E8_PROCESSTOSTART                             0x00000000
#define SPM_E8_PROCESSRUNNING                             0x00000001
#define SPM_E8_PROCESSDOWN                                0x00000002
#define SPM_E8_PROCESSCONFIGUREDOUT                       0x00000003

// SPM_START_PROC_TYPE
#define SPM_START_PROC_TYPE_OSAL_SPAWN                    0x00000000
#define SPM_START_PROC_TYPE_NATIVE_SPAWN                  0x00000001
#define SPM_START_PROC_TYPE_SCRIPT                        0x00000002
#define SPM_START_PROC_TYPE_ADD_SUPERVISION               0x00000003
#define SPM_START_PROC_TYPE_SYSTEMD                       0x00000004

// SPM_MRESULT
#define SPM_MRESULT_NOK                                   0xffffffffffffffff
#define SPM_MRESULT_OK                                    0x00000000

// SPM_RUNLEVEL
#define SPM_RUNLEVEL_LCM_STARTED                          0x00000000
#define SPM_RUNLEVEL_SYSTEM_STARTED                       0x00000001
#define SPM_RUNLEVEL_SYSTEM_UP                            0x00000002
#define SPM_RUNLEVEL_SYSTEM_RUNNING                       0x00000003
#define SPM_RUNLEVEL_RESTART_REQUESTED                    0x00000004
#define SPM_RUNLEVEL_SYNC_STARTED                         0x00000005
#define SPM_RUNLEVEL_RESTART_NOW                          0x00000006
#define SPM_RUNLEVEL_SHUTDOWN_STARTED                     0x00000007
#define SPM_RUNLEVEL_SHUTDOWN_UNMOUNT                     0x00000008
#define SPM_RUNLEVEL_SHUTDOWN_NOW                         0x00000009

// SPM_REDUCTION_LEVEL
#define SPM_REDUCTION_LEVEL_INACTIVE                      0x00000000
#define SPM_REDUCTION_LEVEL_ACTIVE_1                      0x00000001
#define SPM_REDUCTION_LEVEL_ACTIVE_2                      0x00000002
#define SPM_REDUCTION_LEVEL_ACTIVE_3                      0x00000003
#define SPM_REDUCTION_LEVEL_ACTIVE_4                      0x00000004

// SPM_CLEAR_LIST
#define SPM_CLEAR_LIST_ALL                                0x00000000
#define SPM_CLEAR_LIST_ERROR_HISTORY                      0x00000001
#define SPM_CLEAR_LIST_WAKEUP_HISTORY                     0x00000002
#define SPM_CLEAR_LIST_RESET_HISTORY                      0x00000003
#define SPM_CLEAR_LIST_STATE_HISTORY                      0x00000004
#define SPM_CLEAR_LIST_TRANSPORT_HISTORY                  0x00000005
#define SPM_CLEAR_LIST_SWITCH_ON_HISTORY                  0x00000006

// SPM_UPDATELOCKCOMMAND
#define SPM_E8_USE                                        0x00000000
#define SPM_E8_RESERVE                                    0x00000001
#define SPM_E8_LOCK                                       0x00000002
#define SPM_E8_MASTERLOCK                                 0x00000003
#define SPM_E8_RELEASE                                    0x00000004

// SPM_UPDATELOCKSTATE
#define SPM_E8_USED                                       0x00000001
#define SPM_E8_RESERVED                                   0x00000002
#define SPM_E8_LOCKING                                    0x00000003
#define SPM_E8_LOCKED                                     0x00000004

// SPM_DEFSETMODE
#define SPM_DEFSET_SRC_NOT_DEF                            0x000000ff
#define SPM_DEFSET_SRC_SET_USER                           0x00000000
#define SPM_DEFSET_SRC_SET_TEF                            0x00000001
#define SPM_DEFSET_SRC_UPREG                              0x00000002
#define SPM_DEFSET_SRC_RELUPREG                           0x00000003
#define SPM_DEFSET_SRC_GET                                0x00000004
#define SPM_DEFSET_SRC_SET_OEM                            0x00000005

// SPM_DEFSETSERVICESTATUS
#define SPM_DEFSET_STATE_UNDEFINED                        0x000000ff
#define SPM_DEFSET_STATE_CONFIRMED                        0x00000000
#define SPM_DEFSET_STATE_FAILED                           0x00000001

// SPM_DIAGLOGDEFSETTYPE
#define SPM_CLEAR_ERRMEM                                  0x00000001
#define SPM_ACTIVATE_DEACTIVATE_DTC                       0x00000002

// SPM_DEFSETGROUP
#define SPM_DEFSET_GROUP_SPM                              0x00000015
#define SPM_DEFSET_GROUP_INFOTAINMENT_AUDIO               0x00000009
#define SPM_DEFSET_GROUP_MAINTENANCE                      0x0000000d
#define SPM_DEFSET_GROUP_COMPLETE                         0x000000ff


// FID properties
#define FID_SPM_SYSTEMSTATE                                   0x0001
#define FID_SPM_DOWNLOADLOCKSTATES                            0x1002
#define FID_SPM_UPDATELOCKSTATES                              0x1004
#define FID_SPM_ACTIVEONOFFTRIGGER                            0x110f
#define FID_SPM_SUBSTATES                                     0x000f
#define FID_SPM_HISTORYTRIGGER                                0x20
#define FID_SPM_INSERTSTATE                                   0x21
#define FID_SPM_MEDIAEJECTSTATE                               0x22
#define FID_SPM_PHONEMUTESTATE                                0x23
#define FID_SPM_ONTIPPERSTATE                                 0x25
#define FID_SPM_IGNITIONCYCLES                                0x0203
#define FID_SPM_SYSPWRMODE                                    0x0204
#define FID_SPM_SYSPWRSAVEMODE                                0x0205
#define FID_SPM_MAPDOWNLOADLOCKSTATE                          0x206
#define FID_SPM_STANDBYTIME                                   0x05
#define FID_SPM_PERSITENTSTANDBYTIME                          0x06
#define FID_SPM_IGNITIONOFFTIME                               0x08
#define FID_SPM_DOOROPENTIME                                  0x0a
#define FID_SPM_CLOCKDISPLAYTIME                              0x0b
#define FID_SPM_SYSTEMSTATETIME                               0xe8
#define FID_SPM_PROCESSLIST                                   0x1ff
#define FID_SPM_WAKEUPREASON                                  0x70
#define FID_SPM_STARTUPREASON                                 0x71
#define FID_SPM_CONNECTTOBATTERY                              0x72
#define FID_SPM_CODEREQUESTSTATE                              0x60
#define FID_SPM_ACTIVESTARTUPSYNCPOINTS                       0x161
#define FID_SPM_CVMEVENT                                      0x38
#define FID_SPM_UBATSENSE                                     0x83
#define FID_SPM_COPROSTATE                                    0x31
#define FID_SPM_DEVICEPOWERONTIME                             0x18
#define FID_SPM_LASTSYSTEMRUNTIME                             0x1100
#define FID_SPM_CURRENTSYSTEMRUNTIME                          0x1101
#define FID_SPM_RESETLIST                                     0x41
#define FID_SPM_RESETCOUNTER                                  0x1041
#define FID_SPM_TRANSPORTMODELIST                             0x43
#define FID_SPM_RESETHISTORY                                  0x44
#define FID_SPM_WAKEUPHISTORY                                 0x45
#define FID_SPM_STATEHISTORY                                  0x46
#define FID_SPM_ERRSTATEHISTORY01                             0x47
#define FID_SPM_ERRSTATEHISTORY02                             0x48
#define FID_SPM_ERRSTATEHISTORY03                             0x49
#define FID_SPM_ERRSTATEHISTORY04                             0x4a
#define FID_SPM_ERRSTATEHISTORY05                             0x4b
#define FID_SPM_SWITCHONHISTORY                               0x4c
#define FID_SPM_DEVICEONCOUNTER                               0x1050
#define FID_SPM_VOLTAGEEVENTCOUNTER                           0x1051
#define FID_SPM_VOLTAGERANGEHISTOGRAM                         0x1052
#define FID_SPM_CPUUSAGESTATISTIC                             0x1053
#define FID_SPM_RAMUSAGESTATISTIC                             0x1054
#define FID_SPM_STARTUPTIMESTATISTIC                          0x1055
#define FID_SPM_SWVERSIONSTATISTIC                            0x1056
#define FID_SPM_RUNLEVELSTATE                                 0x1141
#define FID_SPM_RESTART                                       0x40
#define FID_SPM_LIFESIGN                                      0x0275
#define FID_SPM_HMISTATE                                      0x10
#define FID_SPM_SYSTEMPOWERBEHAVIOUR                          0x1010
#define FID_SPM_DIMSTATE                                      0x11
#define FID_SPM_DIMMINGSTATE                                  0x1011
#define FID_SPM_BLUETOOTHSTATE                                0x13
#define FID_SPM_AUDIOSTATE                                    0x14
#define FID_SPM_SPISTATE                                      0x15
#define FID_SPM_TUNERSTATE                                    0x17
#define FID_SPM_WIFISTATE                                     0x19
#define FID_SPM_ONOFFREASON                                   0x02
#define FID_SPM_WAKEUPLIST                                    0x42
#define FID_SPM_STARTUPFINISHED                               0x0105
#define FID_SPM_SYSSTATE                                      0x0302
#define FID_SPM_MOSTSTATE                                     0x0303
#define FID_SPM_MOSTVERSION                                   0x0304
#define FID_SPM_RVCSTATE                                      0x0235
#define FID_SPM_TRIGGERMOSTREMOTERESET                        0x0701
#define FID_SPM_PARTNUMBER                                    0x0702
#define FID_SPM_PARTNUMBERS                                   0x0703
#define FID_SPM_ALPHACODE                                     0x0704
#define FID_SPM_ALPHACODES                                    0x0705
#define FID_SPM_MANUFACTURERSENABLECOUNTER                    0x0604
#define FID_SPM_NOCALIBRATIONSTATE                            0x0605
#define FID_SPM_SECURITYCOMMERROR                             0x84
#define FID_SPM_SECURITYMORETHAN10VIN                         0x85
#define FID_SPM_SECURITYINVALIDVIN                            0x86
#define FID_SPM_SECURITYCURRENTVIN                            0x87
#define FID_SPM_SECURITYVINHISTORY                            0x88
#define FID_SPM_VIN                                           0x0521
#define FID_SPM_SECURITYSTATE                                 0x0523
#define FID_SPM_VEHICLEID                                     0x0524
#define FID_SPM_DISPLAYVARIANT                                0x0406
#define FID_SPM_REDUCTIONLEVEL                                0x0802
#define FID_SPM_STARTUPSTATE                                  0x03
#define FID_SPM_ENTERTAINMUTE                                 0x16
#define FID_SPM_WELCOMEAUDIOSTATE                             0x2026
#define FID_SPM_UNBALLASTTIMEFROMENGINESTOPPED                0x760
#define FID_SPM_UNBALLASTTIMEBEFOREUNBALLAST                  0x761
#define FID_SPM_UNBALLASTWARNINGTIME                          0x762
#define FID_SPM_DEGRADEDCOUNT                                 0x763
#define FID_SPM_DEGRADEDTIME                                  0x764
#define FID_SPM_PHONEHANDOVERWARNTIME                         0x1018
// FID methods
#define FID_SPM_SYSTEMMODE                                    0x1000
#define FID_SPM_DOWNLOADLOCKSTATE                             0x1001
#define FID_SPM_UPDATELOCK                                    0x1003
#define FID_SPM_ONOFFTRIGGER                                  0x100f
#define FID_SPM_STARTPROCESS                                  0x01fe
#define FID_SPM_STOPPROCESS                                   0x01fd
#define FID_SPM_RESTARTPROCESS                                0x01fc
#define FID_SPM_STARTUPSYNCPOINTREACHED                       0x160
#define FID_SPM_CLEARLIST                                     0x1040
#define FID_SPM_SPECIFICSWVERSIONSTATISTIC                    0x1057
#define FID_SPM_RESTARTSYSTEM                                 0x1042
#define FID_SPM_AUDIOSOURCECHANGE                             0x1017
#define FID_SPM_CHANGEBLUETOOTHSTATE                          0x413
#define FID_SPM_CHANGEAUDIOSTATE                              0x414
#define FID_SPM_CHANGESPISTATE                                0x415
#define FID_SPM_CHANGETUNERSTATE                              0x417
#define FID_SPM_CHANGEWIFISTATE                               0x419
#define FID_SPM_SHUTDOWNANDTERMINATECCAAPPS                   0x0004
#define FID_SPM_SETFACTORYSETTINGSNEW                         0x89
#define FID_SPM_CLEARVIN                                      0x0522
#define FID_SPM_PREPAREDOWNLOAD                               0x0900
#define FID_SPM_ENDDOWNLOAD                                   0x0901
#define FID_SPM_SETONCONFIGURATION                            0x0902
#define FID_SPM_SETPROCESSCONFIGURATION                       0x0903
#define FID_SPM_ENTERTAINDEMUTE                               0x1016
#define FID_SPM_ENTERTAINMUTEREQUEST                          0x1015
#define FID_SPM_WELCOMEAUDIOACTIVATION                        0x1025

