/*!
  * \file  spm_TimerHandler_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclTimerHandler_include_ext: user specific code start
#include "spm_TimerHandler.h"
// spm_tclTimerHandler_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_TimerHandler_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclTimerHandler_include_spm: user specific code start
// spm_tclTimerHandler_include_spm: user specific code end


tVoid spm_tclTimerHandler::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMSTARTTIMER:
      {
         // Start a timer --> Parameter [Name] [interval] [cycle] [msgig].
         const tChar* pString1 = (const tChar*)&puchData[3];
         tU32 param2 = (tU32)((puchData[53]<<24) | (puchData[54]<<16) | (puchData[55]<<8) | puchData[56]);
         tU32 param3 = (tU32)((puchData[57]<<24) | (puchData[58]<<16) | (puchData[59]<<8) | puchData[60]);
         tU32 param4 = (tU32)((puchData[61]<<24) | (puchData[62]<<16) | (puchData[63]<<8) | puchData[64]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmStartTimer' was called: param1 = '%20s', param2 = 0x%x, param3 = 0x%x, param4 = 0x%x", (const tChar*)pString1, param2, param3, param4 ) );

         // SpmStartTimer: user specific code start
         vStartTimer("ISpmTimerHandler", pString1, param2, param3, param4);
         // SpmStartTimer: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclTimerHandlerFunction: user specific code start
     // spm_tclTimerHandlerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclTimerHandlerFile: user specific code start
// spm_tclTimerHandlerFile: user specific code end

