/************************************************************************
  * FILE:         spm_IWakeupHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Interface to spm_tclWakeupHandler.
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 21.01.14  | CM-AI/EPB2 Kollai    | initial version
  *
  *************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#include "spm_ISpmBase.h"

// wakeup reason definition used from cfc-fi e.g. "spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_POWER_ON"
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

// starttype definition
#define SPM_U8_STARTTYPE_COLDSTART             (tU8)0x00
#define SPM_U8_STARTTYPE_RESTART_SCC           (tU8)0x01
#define SPM_U8_STARTTYPE_WARMSTART             (tU8)0x02
#define SPM_U8_STARTTYPE_RESTART_AP            (tU8)0x03
#define SPM_U8_STARTTYPE_UNKNOWN               (tU8)0xFF

// resettype definition
#define SPM_U8_AP_RST_APP_ERROR                      0
#define SPM_U8_AP_RST_ECU_RESET                      1
#define SPM_U8_AP_RST_USER                           2
#define SPM_U8_AP_RST_DOWNLOAD                       3
#define SPM_U8_AP_RST_DOWNLOAD_ERROR                 4
#define SPM_U8_AP_RST_POWER_ON_RESET                 5
#define SPM_U8_AP_RST_POWER_LOSS                     6
#define SPM_U8_AP_RST_POWER_OFF                      7
#define SPM_U8_AP_RST_SCC                            8
#define SPM_U8_AP_RST_UNSPICIFIED                    9
#define SPM_U8_AP_RST_SWITCH_BOOT_MODE_EMMC          10
#define SPM_U8_AP_RST_SWITCH_BOOT_MODE_USB           11
#define SPM_U8_AP_RST_UNKNOWN                        12
#define SPM_U8_AP_RST_SOFTWARE                       13
#define SPM_U8_AP_RST_OVERTEMPERATURE                14
#define SPM_U8_AP_RST_LCM_INTERN                     15

#define SPM_U8_SCC_RST_START                          100
#define SPM_U8_SCC_RST_HW_WATCHDOG                    100
#define SPM_U8_SCC_RST_POWER_ON                       101
#define SPM_U8_SCC_RST_COLDSTART                      102
#define SPM_U8_SCC_RST_APPMODE_CHANGE                 103
#define SPM_U8_SCC_RST_DURING_LPW                     104
#define SPM_U8_SCC_RST_DURING_PLL_OSZ                 105
#define SPM_U8_SCC_RST_DURING_SW                      106
#define SPM_U8_SCC_RST_WARMSTART                      107

#define SPM_U8_NO_RESET                               255

class ISpmWakeupHandler : public ISpmBase
{
public:
ISpmWakeupHandler( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmWakeupHandler( ){}

virtual const tChar*getInterfaceName( ) const { return( "ISpmWakeupHandler" ); }

virtual tU8  u8GetStartMode( )                            = 0;

virtual tU32 u32GetWakeupReason( )                        = 0;

virtual tBool bIsReset( )                                 = 0;

virtual tBool u8GetResetCounter( )                        = 0;

virtual tVoid vSetResetCounter( tU8 u8ResetCounter )      = 0;

virtual tVoid vSetWakeupConfiguration( tU32 u32ConfigNb ) = 0;

};

