/************************************************************************
  * FILE:         spm_ITimerHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Interface to spm_tclTimerHandler.
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2018 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 25.04.18  | CM-CI1/ERN2-E Kollai | initial version
  *
  *************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"

class ISpmTimerHandler : public ISpmWorkerClient
{
public:
    ISpmTimerHandler( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmTimerHandler( ){}

// Implementation of interface ISpmWorkerClient + ISpmBase
virtual tVoid vGetReferences( ) = 0;

virtual tVoid vStartCommunication( ) = 0;

virtual const tChar*getName( ) const                              = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmTimerHandler" ); }

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                                             = 0;

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )                                         = 0;


virtual tVoid vHandleTraceMessage( const tUChar *puchData )                                  = 0;

virtual tVoid vStartTimer(std::string strClientIfName, std::string strTimeName, tU32 u32Intervall, tU32 u32CycleTime, tU32 u32Message) = 0;

};

