/**
  * \file spm_rootdaemon_claller.cpp
  *  \brief
  *    This file contains the LCM/SPM root daemon caller interface function
  *    which is used to trigger LCM/SPM related root daemon operations within
  *    the root daemon.
  *
  *  \b PROJECT      : Generic
  *  \b SW-COMPONENT : LCM
  *  \b COPYRIGHT    : (c) 2015 Robert Bosch GmbH, Hildesheim
  */

/*
  ****************************************************************************

   INCLUDES

  ****************************************************************************
  */

#include "RootDaemonHelper.h"

extern "C"
{
#include "spm_rootdaemon.h"

/*
  ****************************************************************************

   FUNCTION DECLARATIONS

  ****************************************************************************
  */

// [ksm2hi, 25.06.2020] :
//
// After changing the system() calls to ShellCmd::exec() in the
// "spm_rootdaemon_client.cpp", the fc_spm_rootdaemon_client.so depends on the
// symbols of the introduced ShellCmd. As there is no explicit library for
// the ShellCmd symbols we can no longer link the fc_spm_rootdaemon_client.so
// against the procbaseearly.
//
// Therefore we no longer check if the probaseearly runs as root user and
// wouldn't need to execute the root commands via the rootdaemon. Even if the
// probaseearly runs as root we now pass the root command to the rootdaemon
// for execution although this wouldn't be necessary.
#if 0
// Function SPM_ROOTDAEMON_CLIENT_rPerformRootOpAsRoot() resides in file spm_rootdaemon_client.cpp
extern CmdData SPM_ROOTDAEMON_CLIENT_rPerformRootOpAsRoot( const int   cmdNum,
                                                           std::string args );
#endif
/*
  ****************************************************************************

   FUNCTIONS

  ****************************************************************************
  */

CmdData SPM_ROOTDAEMON_CALLER_rPerformRootOp( const char                 *clientName,
                                              const tenRootDaemonCommands cmdNum,
                                              const char                 *args ){
/**
  *  \brief This function performs the LCM/SPM related root operations either
  *         directly or via the root daemon, depending if it is executed as
  *         user "root" or any other user like "eco_lcm".
  *
  *  \return Result from the performed operation passed in structure 'CmdData'.
  */


// [ksm2hi, 25.06.2020] :
//
// After changing the system() calls to ShellCmd::exec() in the
// "spm_rootdaemon_client.cpp", the fc_spm_rootdaemon_client.so depends on the
// symbols of the introduced ShellCmd. As there is no explicit library for
// the ShellCmd symbols we can no longer link the fc_spm_rootdaemon_client.so
// against the procbaseearly.
//
// Therefore we no longer check if the probaseearly runs as root user and
// wouldn't need to execute the root commands via the rootdaemon. Even if the
// probaseearly runs as root we now pass the root command to the rootdaemon
// for execution although this wouldn't be necessary.
#if 0
   // When user is root then perform the root operation directly, otherwise
   // perform the root operation via the root daemon.
   if ( geteuid( ) == 0 ){
      return( SPM_ROOTDAEMON_CLIENT_rPerformRootOpAsRoot( cmdNum, std::string( args ) ) );
   } else {
      return( RootDaemonHelper::performRootOp( clientName,
                                               cmdNum,
                                               std::string( args ) ) );
   }
#else
   return( RootDaemonHelper::performRootOp( clientName,
                                            cmdNum,
                                            std::string( args ) ) );
#endif
}

/******************************************************************************/

} // extern "C"

