/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_OsalWupOnOffEvents.h
  * @brief        This is header file contains functions to check OnOffStates, OnOffEvents status.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include <set>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "spm_IWupOnOffEvents.h"

class ISpmSubStateClient;

/*!
  *  \class spm_tclOsalWupOnOffEvents
  *  \brief  Base class to check OnOffStates, OnOffEvents status.

  */
class spm_tclOsalWupOnOffEvents : public ISpmWupOnOffEvents
{
private:
OSAL_tIODescriptor _hDeviceWupDescr;
OSAL_tEventHandle  _hEventHandle;
OSAL_tThreadID     _hThreadIdWupEvent;

std::set<tU32>          _oDisableSubStateSet;

static tVoid vWupWorkerThread( tVoid *pvArg );

public:
spm_tclOsalWupOnOffEvents( const ISpmFactory& factory );
virtual ~spm_tclOsalWupOnOffEvents( );

virtual tVoid vDisableSubState(tU32 u32SubState, tBool bDisable = TRUE);

protected:
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclOsalWupOnOffEvents" ); }

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

tVoid vGetOnOffEvents( tU32 u32ClientId );

tVoid vGetOnOffStates( tU32 u32ClientId );

virtual tBool bIsOnOffStateActive( tU32 u32SubState );

ISpmSubStateClient *_poclSubStateHandler;

tU32                _u32LastStateWakeups;
};

