/*!
  * \file spm_OsalWupOnOffEvents.cpp
  *  \brief
  *
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author             | Modification
  * 22.11.13  | CM-AI/CB32 Kollai  | initial version
  ******
  */
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// SPM  configuration
#include "spm_Config.h"
#include "spm_GlobDefs.h"

// my class header
#include "spm_OsalWupOnOffEvents.h"

// interfaces class definitions
#include "spm_IFactory.h"
#include "spm_ISubStateClient.h"
#include "spm_ISystemStateManager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_OsalWupOnOffEvents.cpp.trc.h"
#endif

#include "spm_trace.h"

#ifdef SPM_WUP_ONOFF_STATE_MOST_ECL_WAKEUP_ENABLED
   #include "spm_MostProxy_Config.h"
#endif

#define SPM_WUP_NOT_C_U32_EVENT_MASK_STOP_THREAD   0x01000000

#define SPM_WUP_NOT_C_U32_EVENT_MASK_ALL \
   ( DEV_WUP_C_U32_EVENT_MASK_ONOFF_EVENT_CHANGED_NOTIFY   \
     | DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY   \
     | SPM_WUP_NOT_C_U32_EVENT_MASK_STOP_THREAD )


spm_tclOsalWupOnOffEvents::spm_tclOsalWupOnOffEvents( const ISpmFactory& factory ) : ISpmWupOnOffEvents( factory )
   , _hDeviceWupDescr( ( tS32 )OSAL_C_INVALID_HANDLE )
   , _hEventHandle( OSAL_C_INVALID_HANDLE )
   , _hThreadIdWupEvent( OSAL_ERROR )
   , _poclSubStateHandler( NULL )
   , _u32LastStateWakeups( 0 ){

    _oDisableSubStateSet.clear();
}

spm_tclOsalWupOnOffEvents::~spm_tclOsalWupOnOffEvents( ){

   if ( ( _hThreadIdWupEvent != OSAL_ERROR ) && ( _hEventHandle != OSAL_C_INVALID_HANDLE ) ){
      // thread is running --> stop now
         ETG_TRACE_USR1( ( "spm_tclOsalWupOnOffEvents::~spm_tclOsalWupOnOffEvents(): Send event to stop thread" ) );
      if ( OSAL_s32EventPost( _hEventHandle, SPM_WUP_NOT_C_U32_EVENT_MASK_STOP_THREAD, OSAL_EN_EVENTMASK_OR ) == OSAL_OK ){
         ETG_TRACE_ERR( ( "SPM: !!!!!! Error detected !!!!!!" ) );
      }
   }
   _poclSubStateHandler = NULL;
}

tVoid spm_tclOsalWupOnOffEvents::vGetReferences( ){
   // get all needed references now -> all SPM objects are now available
   SPM_GET_IF_REFERENCE_USE_VAR( _poclSubStateHandler, ISpmSubStateClient );
}

tVoid spm_tclOsalWupOnOffEvents::vStartCommunication( ){

   OSAL_trThreadAttribute rAttr;

   std::string            szThreadName = "SpmWupOnOffNot\0";

   // open device
   _hDeviceWupDescr = OSAL_IOOpen( OSAL_C_STRING_DEVICE_WUP, OSAL_EN_READWRITE );
   if ( OSAL_ERROR == _hDeviceWupDescr ){
         ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected in OSAL_IOOpen of DEV_WUP!!!!!!" ) );
      _hDeviceWupDescr = (tS32)OSAL_C_INVALID_HANDLE;
   } else {

      rAttr.szName       = &szThreadName[0];
      rAttr.s32StackSize = 10000;
      rAttr.u32Priority  = 100;
      rAttr.pfEntry      = (OSAL_tpfThreadEntry)vWupWorkerThread;
      rAttr.pvArg        = ( tPVoid ) this;

      _hThreadIdWupEvent = OSAL_ThreadSpawn( &rAttr );

      if ( _hThreadIdWupEvent == OSAL_ERROR ){
         ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
      }
   }
} // vStartCommunication

tVoid spm_tclOsalWupOnOffEvents::vDisableSubState(tU32 u32SubState, tBool bDisable) {
    std::set<tU32>::iterator it = _oDisableSubStateSet.find(u32SubState);
    if ((it != _oDisableSubStateSet.end()) && (!bDisable)) {
        //enable SubState by clear entry from SET
        _oDisableSubStateSet.erase(u32SubState);
    } else if ((it == _oDisableSubStateSet.end()) && (bDisable)) {
        //diaable SubState by insert entry in SET
        _oDisableSubStateSet.insert(u32SubState);
    }
}

/*!
  * \fn
  *  \brief
  *    Worker Thread to handle Wakeup Events and States Changed Notification
  *
  *  \param
  *     tVoid*  -> pointer to this-pointer of the SPM object.
  *  \version
  *    1.0   - Initial
  ******
  */
tVoid spm_tclOsalWupOnOffEvents::vWupWorkerThread( tVoid *pvArg ){
   tBool                                    bStopThread      = FALSE;
   OSAL_tEventMask                          rEventMaskResult = 0;

   spm_tclOsalWupOnOffEvents               *poThis           = (spm_tclOsalWupOnOffEvents*)pvArg;

   DEV_WUP_trClientRegistration             rClientRegistration;

   rClientRegistration.u32ClientId             = 0; // uselesss init parameter, just for LINT

   DEV_WUP_trOnOffReasonChangedRegistration rOnOffReasonChangedRegistration;
   rOnOffReasonChangedRegistration.u32ClientId = 0;               // uselesss init parameter, just for LINT

   if ( OSAL_s32IOControl( poThis->_hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_REGISTER_CLIENT, ( intptr_t )&rClientRegistration ) == OSAL_OK ){
      if ( OSAL_s32EventOpen( rClientRegistration.szNotificationEventName, &poThis->_hEventHandle ) == OSAL_OK ){

         rOnOffReasonChangedRegistration.u32ClientId        = rClientRegistration.u32ClientId;
         rOnOffReasonChangedRegistration.u8NotificationMode = DEV_WUP_C_U8_NOTIFY_STATES_AND_EVENTS_WITH_PAST_ONES;
         rOnOffReasonChangedRegistration.bIsSystemMaster    = TRUE;

         if ( OSAL_s32IOControl( poThis->_hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_REGISTER_ONOFF_REASON_CHANGED_NOTIFICATION, ( intptr_t )&rOnOffReasonChangedRegistration ) == OSAL_OK ){

                        ETG_TRACE_USR1( ( "spm_tclOsalWupOnOffEvents::vWupWorkerThread(): Thread to handle user/project specific voltage change started." ) );
            poThis->vGetOnOffStates( rOnOffReasonChangedRegistration.u32ClientId );

            while ( FALSE == bStopThread ){

               if ( OSAL_s32EventWait( poThis->_hEventHandle, SPM_WUP_NOT_C_U32_EVENT_MASK_ALL, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &rEventMaskResult ) == OSAL_OK ){

                  if ( OSAL_s32EventPost( poThis->_hEventHandle, ~rEventMaskResult, OSAL_EN_EVENTMASK_AND ) == OSAL_OK ){  // Clear evaluated event bits

                     tBool bEventFound = FALSE;
                     if ( rEventMaskResult & DEV_WUP_C_U32_EVENT_MASK_ONOFF_EVENT_CHANGED_NOTIFY ){
                        ETG_TRACE_USR1( ( "spm_tclOsalWupOnOffEvents::vWupWorkerThread(): DEV_WUP_C_U32_EVENT_MASK_ONOFF_EVENT_CHANGED_NOTIFY." ) );
                        poThis->vGetOnOffEvents( rOnOffReasonChangedRegistration.u32ClientId );
                        bEventFound = TRUE;
                     }
                     if ( rEventMaskResult & DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY ){
                        ETG_TRACE_USR1( ( "spm_tclOsalWupOnOffEvents::vWupWorkerThread(): DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY." ) );
                        poThis->vGetOnOffStates( rOnOffReasonChangedRegistration.u32ClientId );
                        bEventFound = TRUE;
                     }
                     if ( rEventMaskResult & SPM_WUP_NOT_C_U32_EVENT_MASK_STOP_THREAD ){
                        bStopThread = TRUE;
                        bEventFound = TRUE;
                     }
                     if ( bEventFound == FALSE ){
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
                     }
                  } else {
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
                  }
               } else {
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
               }
            }

            if ( OSAL_s32IOControl( poThis->_hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_UNREGISTER_ONOFF_REASON_CHANGED_NOTIFICATION, (intptr_t)rOnOffReasonChangedRegistration.u32ClientId ) == OSAL_ERROR ){
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
            }
         } else {
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
         }
      }

      if ( OSAL_s32IOControl( poThis->_hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_UNREGISTER_CLIENT, (intptr_t)rClientRegistration.u32ClientId ) == OSAL_ERROR ){
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
      }
   } else {
                        ETG_TRACE_ERRMEM( ( "SPM: !!!!!! Error detected !!!!!!" ) );
   }
} // vWupWorkerThread

/*!
  * \fn
  *  \brief
  *    This method gets the On/Off Switch States at system-startup.
  *    A Snapshot of these On/Off States is maintained in _rOnOffStates, So, That on
  *    receiving a state on/off change notification, the states can be compared with their snapshot state(previous state)
  *    This method is called before receiving state change events from dev_wup so that state vectors can be compared against each other
  *  \param [out] tBool: True if On/Off States successfully retrieved from dev_wup.
  *  \version
  *    1.0   - Initial
  ******
  */
tVoid spm_tclOsalWupOnOffEvents::vGetOnOffStates( tU32 u32ClientId ){

   SPM_NULL_POINTER_CHECK( _poclSubStateHandler );

   if ( OSAL_ERROR != _hDeviceWupDescr ){
      DEV_WUP_trOnOffStates rOnOffStates;


      rOnOffStates.u16MsgHandle = 0; // uselesss init parameter, just for LINT
      if ( OSAL_s32IOControl( _hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES, ( intptr_t )&rOnOffStates ) == OSAL_ERROR ){
         ETG_TRACE_FATAL( ( "spm_tclOsalWupOnOffEvents::vGetOnOffStates: OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES IOctrl Failed" ) );
      } else {
         DEV_WUP_trOnOffStateAcknowledge rOnOffStateAcknowledge;

         tU32                            u32DataMask = rOnOffStates.uOnOffStates.u32 ^ _u32LastStateWakeups;
         ETG_TRACE_USR1( ( "spm_tclOsalWupOnOffEvents::vGetOnOffStates: OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES : new 0%08x, old 0%08x, mask 0%08x", rOnOffStates.uOnOffStates.u32, _u32LastStateWakeups, u32DataMask ) );
         _u32LastStateWakeups = rOnOffStates.uOnOffStates.u32;
         std::set<tU32>::iterator it;

         #ifdef SPM_WUP_ONOFF_STATE_S_CONTACT_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_ACCESSORY);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_S_CONTACT ) ){
                   // check SCONT state
                   if ( rOnOffStates.uOnOffStates.rBitfield.S_CONTACT == 1 ){
                      _poclSubStateHandler->vSetSubStateType( SPM_U32_ACCESSORY, TRUE );
                   } else if ( rOnOffStates.uOnOffStates.rBitfield.S_CONTACT == 0 ){
                      _poclSubStateHandler->vSetSubStateType( SPM_U32_ACCESSORY, FALSE );
                   }
                }
            }
         #endif
         #ifdef SPM_WUP_ONOFF_STATE_IGNITION_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_IGNITION);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_IGN_PIN ) ){
                   // check ignition state
                   if ( rOnOffStates.uOnOffStates.rBitfield.IGN_PIN == 1 ){
                      _poclSubStateHandler->vSetSubStateType( SPM_U32_IGNITION, TRUE );
                   } else if ( rOnOffStates.uOnOffStates.rBitfield.IGN_PIN == 0 ){
                      _poclSubStateHandler->vSetSubStateType( SPM_U32_IGNITION, FALSE );
                   }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_FLEXRAY_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_CAN_WAKEUP);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_IGN_PIN ) ){
                    if ( rOnOffStates.uOnOffStates.rBitfield.FLEXRAY == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_CAN_WAKEUP, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.FLEXRAY == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_CAN_WAKEUP, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_LIN_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_LIN);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_LIN ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.LIN == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_LIN, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.LIN == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_LIN, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CAN_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_NETWORK_ACTIVITY);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CAN ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.CAN == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.CAN == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CAN2_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_NETWORK_ACTIVITY);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CAN2 ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.CAN2 == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.CAN2 == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CAN3_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_NETWORK_ACTIVITY);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CAN3 ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.CAN3 == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.CAN3 == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CAN4_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_NETWORK_ACTIVITY);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CAN4 ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.CAN4 == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.CAN4 == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_NETWORK_ACTIVITY, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CD_CLAMP_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_CD_INSERT);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CD_CLAMP ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.CD_CLAMP == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_CD_INSERT, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.CD_CLAMP == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_CD_INSERT, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_ILLUMINATION_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_DIMMING);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_ILLUMINATION ) ){
                    // check network state
                    if ( rOnOffStates.uOnOffStates.rBitfield.ILLUMINATION == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_DIMMING, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.ILLUMINATION == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_DIMMING, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_TELEPHONE_MUTE_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_PHONE_MUTE);
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_TELEPHONE_MUTE ) ){
                    // check telephone_mute state
                    if ( rOnOffStates.uOnOffStates.rBitfield.TELEPHONE_MUTE == 1 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_PHONE_MUTE, TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.TELEPHONE_MUTE == 0 ){
                        _poclSubStateHandler->vSetSubStateType( SPM_U32_PHONE_MUTE, FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_EXTERNAL_GPIO_ENABLED
           it = _oDisableSubStateSet.find(SPM_U32_EXTERNAL_GPIO);
           if (it == _oDisableSubStateSet.end()) {
            if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_EXTERNAL_PIN ) ){
               // check external gpio state
               if ( rOnOffStates.uOnOffStates.rBitfield.EXTERNAL_PIN == 1 ){
                _poclSubStateHandler->vSetSubStateType( SPM_U32_EXTERNAL_GPIO, TRUE );
               } else if ( rOnOffStates.uOnOffStates.rBitfield.EXTERNAL_PIN == 0 ){
                _poclSubStateHandler->vSetSubStateType( SPM_U32_EXTERNAL_GPIO, FALSE );
               }
            }
           }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_ODOMETER_ENABLED
         // currently disabled - this wakeup is not yet defined
            it = _oDisableSubStateSet.find();
            if (it == _oDisableSubStateSet.end()) {
                if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_ODOMETER ) ){
                    // check external gpio state
                    if ( rOnOffStates.uOnOffStates.rBitfield.ODOMETER == 1 ){
                        _poclSubStateHandler->vSetSubStateType( , TRUE );
                    } else if ( rOnOffStates.uOnOffStates.rBitfield.ODOMETER == 0 ){
                        _poclSubStateHandler->vSetSubStateType( , FALSE );
                    }
                }
            }
         #endif

         #ifdef SPM_WUP_ONOFF_STATE_CELLNETWORK_ENABLED
            it = _oDisableSubStateSet.find(SPM_U32_CELLNETWORK);
            if (it == _oDisableSubStateSet.end()) {
               if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CELLNETWORK ) ){
                  // check external gpio state
                  if ( rOnOffStates.uOnOffStates.rBitfield.CELLNETWORK == 1 ){
                     _poclSubStateHandler->vSetSubStateType( SPM_U32_CELLNETWORK, TRUE );
                  } else if ( rOnOffStates.uOnOffStates.rBitfield.CELLNETWORK == 0 ){
                     _poclSubStateHandler->vSetSubStateType( SPM_U32_CELLNETWORK, FALSE );
                  }
              }
           }
        #endif

        #ifdef SPM_WUP_ONOFF_STATE_USB_ENABLED
           it = _oDisableSubStateSet.find(SPM_U32_USB);
           if (it == _oDisableSubStateSet.end()) {
              if ( u32DataMask & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_USB ) ){
                  // check external gpio state
                  if ( rOnOffStates.uOnOffStates.rBitfield.USB == 1 ){
                     _poclSubStateHandler->vSetSubStateType( SPM_U32_USB, TRUE );
                  } else if ( rOnOffStates.uOnOffStates.rBitfield.USB == 0 ){
                     _poclSubStateHandler->vSetSubStateType( SPM_U32_USB, FALSE );
                  }
              }
           }
        #endif

         rOnOffStateAcknowledge.u32ClientId            = u32ClientId;
         rOnOffStateAcknowledge.u16OnOffStateMsgHandle = rOnOffStates.u16MsgHandle;
         //acknowledge the processed on/off state to dev_wup if not after PointOfNoReturn
         SPM_GET_IF_REFERENCE_NEW_VAR( poclSystemStateManager, ISpmSystemStateManager );
         if ( !poclSystemStateManager->bPointOfNoReturnReached( ) ){
            if ( OSAL_s32IOControl( _hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_ACKNOWLEDGE_ONOFF_STATE, ( intptr_t )&rOnOffStateAcknowledge ) == OSAL_ERROR ){
               ETG_TRACE_FATAL( ( "SPM:!!!ERROR failed to acknowledge on/off state!!!" ) );
            }
         } else {
            ETG_TRACE_USR1( ( "SPM: wakeup state not acknowledged - after PointOfNoReturn" ) );
         }
      }
   } else {
      ETG_TRACE_FATAL( ( "SPM: !!!!!! Error detected,no handle to dev_wup available !!!!!!" ) );
   }
   return;
} // vGetOnOffStates

/*!
  * \fn
  *  \brief
  *    This method returns the On/Off Switch States of the requested substate based on the last received wup state.
  *  \param [out] tBool: True if substate is active else false.
  *  \version
  *    1.0   - Initial
  ******
  */
tBool spm_tclOsalWupOnOffEvents::bIsOnOffStateActive( tU32 u32SubState ){

   tBool bRet = FALSE;

   if ( u32SubState == SPM_U32_ACCESSORY ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_S_CONTACT ) ){
         bRet = TRUE;
      }
   } else if ( u32SubState == SPM_U32_IGNITION ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_IGN_PIN ) ){
         bRet = TRUE;
      }
   } else if ( u32SubState == SPM_U32_NETWORK_ACTIVITY ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CAN ) ){
         bRet = TRUE;
      }
   } else if ( u32SubState == SPM_U32_CD_INSERT ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_CD_CLAMP ) ){
         bRet = TRUE;
      }
   } else if ( u32SubState == SPM_U32_DIMMING ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_ILLUMINATION ) ){
         bRet = TRUE;
      }
   } else if ( u32SubState == SPM_U32_PHONE_MUTE ){
      if ( _u32LastStateWakeups & ( 1 << DEV_WUP_C_U8_ONOFF_STATE_TELEPHONE_MUTE ) ){
         bRet = TRUE;
      }
   }

   ETG_TRACE_USR4( ( "spm_tclOsalWupOnOffEvents::bIsOnOffStateActive: u32SubState: %u, LastStateWakeups: %u, bRet: %u", ETG_ENUM( SPM_SUBSTATETYPE, u32SubState ), _u32LastStateWakeups, ETG_ENUM( SPM_BOOL_STATE, bRet ) ) );

   return( bRet );
} // bIsOnOffStateActive

/*!
  * \fn
  *  \brief
  *    This method handles the On/Off Events(processes,notifies substate handler and acknowledges them to dev_wup)
  *  \version
  *    1.0   - Initial
  ******
  */
tVoid spm_tclOsalWupOnOffEvents::vGetOnOffEvents( tU32 u32ClientId ){
   DEV_WUP_trOnOffEventHistory rOnOffEventHistory;

   SPM_NULL_POINTER_CHECK( _poclSubStateHandler );

   rOnOffEventHistory.u32ClientId = u32ClientId;
   if ( OSAL_s32IOControl( _hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_EVENTS, ( intptr_t )&rOnOffEventHistory ) == OSAL_OK ){
      DEV_WUP_trOnOffEventAcknowledge rOnOffEventAcknowledge;
      tU8                             u8Index;
      tU8                             u8Event;
      // tU16                            u16MsgHandle;

      rOnOffEventAcknowledge.u32ClientId = u32ClientId;

         ETG_TRACE_USR4( ( "spm_tclOsalWupOnOffEvents::vGetOnOffEvents(): %d On/Off Event(s) detected ", rOnOffEventHistory.u8NumberOfOnOffEvents ) );

      // each and every event has to be acknowledged separately after processing it
      for ( u8Index = 0; u8Index < rOnOffEventHistory.u8NumberOfOnOffEvents; u8Index++ ){
         u8Event = rOnOffEventHistory.arOnOffEvent[u8Index].u8Event;
         ETG_TRACE_USR4( ( "spm_tclOsalWupOnOffEvents::vGetOnOffEvents(): On/Off Event Detected is %d", u8Event ) );

         switch ( u8Event ){
            case DEV_WUP_C_U8_ONOFF_EVENT_POWER_ON_RESET:
            {
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_CSD_HOME_PRESSED:
            {
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_DRIVERS_DOOR_OPENED:
            {
                std::set<tU32>::iterator it = _oDisableSubStateSet.find(SPM_U32_DOOROPEN);
                if (it == _oDisableSubStateSet.end()) {
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_DOOROPEN, TRUE );
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_DOOROPEN, FALSE );
                }
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_DEBUG_WAKEUP:
            {
               _poclSubStateHandler->vSetSubStateType( SPM_U32_ON_TIPPER, TRUE );
               _poclSubStateHandler->vSetSubStateType( SPM_U32_ON_TIPPER, FALSE );

               _poclSubStateHandler->vSetSubStateType( SPM_U32_DEBUG_WAKEUP, TRUE );
               _poclSubStateHandler->vSetSubStateType( SPM_U32_DEBUG_WAKEUP, FALSE );

            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_RTC_WAKEUP:
            {
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_ON_TIPPER_PRESS:
            {
                std::set<tU32>::iterator it = _oDisableSubStateSet.find(SPM_U32_ON_TIPPER);
                if (it == _oDisableSubStateSet.end()) {
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_ON_TIPPER, TRUE );
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_ON_TIPPER, FALSE );
                }
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_IGNITION_PIN:
            {
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_CD_INSERT_DETECTED:
            {
               //set CD clambs active --> will be deactivated by MMGR
               _poclSubStateHandler->vSetSubStateType( SPM_U32_CD_INSERT_CLAMPS, TRUE );
            }
            break;

            case DEV_WUP_C_U8_ONOFF_EVENT_CD_EJECT_DETECTED:
            {
                std::set<tU32>::iterator it = _oDisableSubStateSet.find(SPM_U32_EJECT);
                if (it == _oDisableSubStateSet.end()) {
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_EJECT, TRUE );
                    _poclSubStateHandler->vSetSubStateType( SPM_U32_EJECT, FALSE );
                }
            }
            break;

               #ifdef SPM_WUP_ONOFF_STATE_MOST_RBD_ENABLED
                  case DEV_WUP_C_U8_ONOFF_EVENT_MOST_RBD_DETECTED:
                  {
                     spm_tclMostProxyConfig *MostPrx = dynamic_cast < spm_tclMostProxyConfig* >( _crfFactory.getSpmObjHandler( "spm_tclMostProxyConfig" ) );
                     SPM_NULL_POINTER_CHECK( MostPrx );
                     MostPrx->vSetMostEclStateRbd( TRUE );
                  }
                  break;
                     //check network state
               #endif


               #ifdef SPM_WUP_ONOFF_STATE_MOST_ECL_STG_ENABLED
                  case DEV_WUP_C_U8_ONOFF_EVENT_MOST_ECL_STG_DETECTED:
                  {
                     //check network state
                     spm_tclMostProxyConfig *MostPrx = dynamic_cast < spm_tclMostProxyConfig* >( _crfFactory.getSpmObjHandler( "spm_tclMostProxyConfig" ) );
                     SPM_NULL_POINTER_CHECK( MostPrx );
                     MostPrx->vSetMostEclStateStg( TRUE );
                  }
                  break;
               #endif


               #ifdef SPM_WUP_ONOFF_STATE_MOST_UNDEF_ENABLED
                  case DEV_WUP_C_U8_ONOFF_EVENT_MOST_UNDEF_DETECTED:
                  {
                     //check network state
                     spm_tclMostProxyConfig *MostPrx = dynamic_cast < spm_tclMostProxyConfig* >( _crfFactory.getSpmObjHandler( "spm_tclMostProxyConfig" ) );
                     SPM_NULL_POINTER_CHECK( MostPrx );
                     MostPrx->vSetMostEclStateUndef( TRUE );
                  }
                  break;
               #endif

               #ifdef SPM_WUP_ONOFF_STATE_MOST_ECL_WAKEUP_ENABLED
                  case DEV_WUP_C_U8_ONOFF_EVENT_MOST_ACTIVE_DETECTED:
                  {
                     //check network state
                     spm_tclMostProxyConfig *MostPrx = dynamic_cast < spm_tclMostProxyConfig* >( _crfFactory.getSpmObjHandler( "spm_tclMostProxyConfig" ) );
                     SPM_NULL_POINTER_CHECK( MostPrx );
                     MostPrx->vSetMostEclStateWakeUp( TRUE );
                  }
                  break;

               #endif
            default:
            {
               ETG_TRACE_ERRMEM( ( "unknown On/Off event value detected %d", u8Event ) );
            }
         } // switch

         rOnOffEventAcknowledge.u16OnOffEventMsgHandle = rOnOffEventHistory.arOnOffEvent[u8Index].u16MsgHandle;
         // acknowledge the processed on/off event to dev_wup if not after PointOfNoReturn
         SPM_GET_IF_REFERENCE_NEW_VAR( poclSystemStateManager, ISpmSystemStateManager );
         if ( !poclSystemStateManager->bPointOfNoReturnReached( ) ){
            if ( OSAL_s32IOControl( _hDeviceWupDescr, OSAL_C_S32_IOCTRL_WUP_ACKNOWLEDGE_ONOFF_EVENT, ( intptr_t )&rOnOffEventAcknowledge ) == OSAL_ERROR ){
               ETG_TRACE_FATAL( ( "SPM:!!!ERROR failed to acknowledge on/off event!!!" ) );
            }
         } else {
            ETG_TRACE_USR1( ( "SPM: wakeup event not acknowledged - after PointOfNoReturn" ) );
         }
      }
   } else {
      ETG_TRACE_FATAL( ( "SPM!!ERROR!!Unable to get the event history from dev_wup!!" ) );
   }
} // vGetOnOffEvents

// EOF

