/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_OsalCvm.h
  * @brief        This is header file contains functions for user voltage level handling.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include <list>
#include <set>

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "spm_ISpmOsalCvm.h"

class ISpmCvmClient;
class ISpmWorkerServer;

/*!
  *  \class spm_tclOsalCvm
  *  \brief  Base class to handle user voltage level handling.

  */
class spm_tclOsalCvm : public ISpmOsalCvm
{
private:
OSAL_tIODescriptor _hDeviceVoltDescr;
OSAL_tEventHandle  _hEventHandle;
OSAL_tThreadID     _hThreadIdCvmEvent;
tU32               _u32ClientId;

tU32               _u32PreviousSystemVoltage;

typedef struct
{
   tU16 u16VoltageLevel;
   tBool bBelow;
   ISpmCvmUserClient *pRef;
} TClientInfo;

std::list < TClientInfo > _oClientList;


static tVoid vCvmWorkerThread( tVoid *pvArg );

ISpmCvmClient            *_poCvmClient;
ISpmWorkerServer         *_poclWorkerServer;

public:
spm_tclOsalCvm( const ISpmFactory& factory );
virtual ~spm_tclOsalCvm( );

virtual tBool bAddUserVoltClient( ISpmCvmUserClient *client,
                                  tU16               u16VoltageLevel,
                                  tU16               u16Hysteresis = DEV_VOLT_CONF_C_U16_BOARD_VOLTAGE_HYSTERISIS_MV );

virtual tBool bRemoveUserVoltClient( ISpmCvmUserClient *client );

protected:
virtual tVoid vProcessSystemStateNotification( );

virtual const tChar*getName( ) const { return( "spm_tclOsalCvm" ); }
virtual const tChar*getInterfaceName( ) const { return( "ISpmOsalCvm" ); }

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );

};

