/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_OsLinux.h
  * @brief        This is header file contains Linux abstraction functions.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IOsLinux.h"

class ISpmOsalProxy;
class ISpmSystemPowerManager;

/*!
  *  \class spm_tclOsLinux
  *  \brief This class represents linux abstraction in general OSAL based SPM .
        The spm_tclFactory object creates an instance of this class.
        It is used by class _poOsLinuxHdl for system reboot or halt and get thread or process ID.
  */
class spm_tclOsLinux : public ISpmOsLinux
{
private:
ISpmOsalProxy          *_poclOsalProxy;
ISpmSystemPowerManager *_poclSystemPowerManager;
OSAL_tSemHandle         _hLxPrxSem;

public:
spm_tclOsLinux( const ISpmFactory& factory );
virtual ~spm_tclOsLinux( );

virtual tU32  u32GetCpuLoad( tVoid );

virtual tBool bSystemHalt( tVoid );
virtual tBool bSystemReboot( tVoid );
virtual tBool bReniceProcess( const std::string& strProcessName );

virtual tBool bSetReductionLevel( tU32 u32Level );

virtual tBool bSetSupervision( tU32 u32Action );

virtual tBool bSupervisionWarning( tVoid );
virtual tBool bSupervisionReset( tVoid );

virtual tBool bTriggerTimeTracker( tBool bProcesses = FALSE );

virtual tBool bGetReadyThreads( tVoid );
virtual tBool bGetThreadInfo( const std::string& strThreadName );

virtual tBool bGetProcessInfo( const std::string& strProcessName,
                               tBool              bDumpCallstacks = TRUE,
                               const std::string& strStartType = SPM_STARTUP_VALUE_OSAL_START_TYPE );

virtual tBool bGetProcessInfo( tU32  u32ProcdId,
                               tBool bDumpCallstacks = TRUE );

virtual tBool bEmTraceEntry( const std::string& strEntry );

virtual tBool bTriggerExceptionHandler( tS32        pid,
                                        std::string message );

virtual tBool bStopProcess( const std::string& strLocation,
                            const std::string& strShEvent,
                            tU32               u32ProcId = 0 );

virtual tS32  s32StartProcess( const std::string& strLocation,
                               tU32               u32Type,
                               tU32               u32NiceLevel = 0,
                               tU32               u32NiceLevelEnd = 0,
                               tU32               u32Prio = 0,
                               tU32               u32Affinity = 0,
                               tU32               u32AffinityEnd = 0 );

virtual tBool bSyncFilesystem( tU32 u32Timeout = 20000 );

virtual tBool bShutdown( tU32 u32Timeout = 10000 );

virtual tBool bWaitForSrv( tU32 u32Timeout );

virtual tS32  s32ReadFileContent( const std::string& strFile,
                                  std::string      & strBuf,
                                  tU32               u32Len );

virtual tBool bIsFileInFs( const std::string& strFile );

virtual tBool bMkDir( const std::string& strFile );

virtual tVoid vRunCommandLine( const std::string strCmdLine );

// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

protected:
virtual const tChar*getName( ) const { return( "spm_tclOsLinux" ); }

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

};

