/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IWupSupervisionErrorWarning.h
  * @brief        This is header file contains functions for Supervision Warning.
  * @copyright    (C) 2017 Robert Bosch Engineering and Business Solutions Vietnam Company
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */



#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
class ISpmWupSupervisionErrorWarning : public ISpmBase
{
public:
ISpmWupSupervisionErrorWarning( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmWupSupervisionErrorWarning( ){}
virtual tVoid vDumpInfo(tU8 /*u8ErrorCode*/) {}
virtual const tChar*getInterfaceName( ) const { return( "ISpmWupSupervisionErrorWarning" ); }

};
