/*!
  * \file spm_appsim.cpp
  *  \brief
  *       Constructor / Destructor based semaphore handling
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author                | Modification
  * 07.03.14  | CM-AI/EPB2 Kollai  | initial version
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

// SPM  configuration
#include "spm_Config.h"

// my class header
#include "spm_appsim.h"

// spm class definitions

// interfaces class definitions
#include "spm_trace.h"

#define SPM_SIM_MSG_QUEUE_NAME_PREFIX          "mbx_"
#define SPM_SIM_MSG_QUEUE_NAME_POSTFIX_FORMAT  "%s%u" // %u is filled with tU16 = 5 decimal places
#define SPM_SIM_MSG_QUEUE_NAME_LENGTH          ((tU8)(sizeof(SPM_SIM_MSG_QUEUE_NAME_PREFIX)+5))

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_appsim.cpp.trc.h"
#endif

spm_tclAppSim::spm_tclAppSim( const ISpmFactory& factory,
                              const std::string& strAppName,
                              tU16               u16AppId,
                              tU16               u16SrvId ) : ISpmBase( factory ){

   _u16AppId       = u16AppId;
   _u16SrvId       = u16SrvId;

   _strAppName     = strAppName;

   _bTerminate     = FALSE;
   _bThreadRunning = FALSE;

   _hCcaInQueue    = OSAL_C_INVALID_HANDLE;

   // add APP ID in registry

   // add SRV ID in registry

   // start receiving thread
   OSAL_trThreadAttribute rAttr;
   std::string            strThreadName = "Sim";
   strThreadName     += _strAppName;

   rAttr.szName       = (const tString)strThreadName.c_str( ); //lint !e1773 PQM_authorized_379
   rAttr.s32StackSize = 4096;
   rAttr.u32Priority  = 100;
   rAttr.pfEntry      = (OSAL_tpfThreadEntry)vCcaMsgHandlerThread;
   rAttr.pvArg        = ( tPVoid ) this;

   _hThreadId         = OSAL_ThreadSpawn( &rAttr );
   if ( _hThreadId == OSAL_ERROR ){
      ETG_TRACE_ERR( ( "spm_tclAppSim::spm_tclAppSim(): Failed to spawn thread!" ) );
   }
}

spm_tclAppSim::~spm_tclAppSim( ){
   _bTerminate = TRUE;
   while ( !_bThreadRunning ){
      OSAL_s32ThreadWait( 100 );
   }
   tChar strName[SPM_SIM_MSG_QUEUE_NAME_LENGTH];

   if (OSALUTIL_s32SaveNPrintFormat(
      strName,
      sizeof(strName),
      SPM_SIM_MSG_QUEUE_NAME_POSTFIX_FORMAT,
      SPM_SIM_MSG_QUEUE_NAME_PREFIX,
      _u16AppId) == OSAL_ERROR) {
         tU32 u32ErrorReason = OSAL_u32ErrorCode( );
         ETG_TRACE_ERRMEM( ( "SPM: spm_tclAppSim desstructor !!!!!! Error detected !!!!!! cannot create MessageQueue name for _hCcaInQueue: error 0x%08X (%s)",
                             (tUInt)u32ErrorReason, OSAL_coszErrorText( u32ErrorReason ) ) );
     return;
   }

   OSAL_s32MessageQueueClose( _hCcaInQueue );
   OSAL_s32MessageQueueDelete( strName );

}

tVoid spm_tclAppSim::vCcaMsgHandlerThread( tVoid *pvArg ){
/*!
  * \fn
  *  \brief
  *    Creates message queue named mbx_appid for the application and waits for message
  *
  *  \param
  *    void pointer to the spm_tclAppSim object
  *
  ******
  */
   spm_tclAppSim *myRef = (spm_tclAppSim*)pvArg;

   // create message queue
   tChar strName[SPM_SIM_MSG_QUEUE_NAME_LENGTH];

   if (OSALUTIL_s32SaveNPrintFormat(
      strName,
      sizeof(strName),
      SPM_SIM_MSG_QUEUE_NAME_POSTFIX_FORMAT,
      SPM_SIM_MSG_QUEUE_NAME_PREFIX,
      myRef->_u16AppId) == OSAL_ERROR) {
         tU32 u32ErrorReason = OSAL_u32ErrorCode( );
         ETG_TRACE_ERRMEM( ( "SPM: spm_tclAppSim::vCcaMsgHandlerThread !!!!!! Error detected !!!!!! cannot create MessageQueue name for _hCcaInQueue: error 0x%08X (%s)",
                             (tUInt)u32ErrorReason, OSAL_coszErrorText( u32ErrorReason ) ) );
     return;
   }

   if ( OSAL_ERROR == OSAL_s32MessageQueueCreate(
           strName,
           20,
           SCD_MAILBOX_MAX_MESSAGE_LENGTH,
           OSAL_EN_READWRITE,
           &myRef->_hCcaInQueue
           )
        ){
      myRef->_hCcaInQueue = OSAL_C_INVALID_HANDLE;
   }
   myRef->_bThreadRunning = TRUE;

   while ( !myRef->_bTerminate ){
      amt_tclBaseMessage oMsgObject;
      tS32               s32RetVal = OSAL_s32MessageQueueWait(
         myRef->_hCcaInQueue,
         (tU8*)oMsgObject.prGetOSALMsgHandle( ), /*pointer of the MsgHandle field*/
         sizeof( OSAL_trMessage ),
         OSAL_NULL,
         1000
         );

      if ( s32RetVal != OSAL_ERROR ){
         // gets the pointer to shared memory
         if ( sizeof( OSAL_trMessage ) == s32RetVal ){
            oMsgObject.pu8SharedMemBase = OSAL_pu8MessageContentGet( * ( oMsgObject.prGetOSALMsgHandle( ) ), OSAL_EN_READWRITE );
            if ( oMsgObject.pu8SharedMemBase != OSAL_NULL ){
               // print message
               ETG_TRACE_FATAL( ( "CCAMSG: RCV: %*p.!", ETG_LIST_LEN( oMsgObject.u32GetSize( ) ), ETG_LIST_PTR_T8( oMsgObject.pu8SharedMemBase ) ) );
               ETG_TRACE_FATAL( ( "CCAMSG: END." ) );
            }
         } else {
            if ( OSAL_u32ErrorCode( ) != OSAL_E_TIMEOUT ){
               // error
            } else {
               // timeout
            }
         }
      } else {
         // ETG_TRACE_ERR_CLS((SPM_TRACE_CLASS_SPM, "bMessageQueueWait, receive error: %s", OSAL_coszErrorText(OSAL_u32ErrorCode())));
      }
   }

   myRef->_bThreadRunning = FALSE;
} // vCcaMsgHandlerThread

// EOF

