/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IRegistry.h
  * @brief        This is header file contains interfaces to handles registry related operations.
  * @copyright    (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <vector>
#include <map>
#include <string>

#include "spm_Config.h"
#include "spm_ISpmBase.h"

#define SPM_STARTUP_SYNC_REG_NAME                               "PROCSTARTED"

/*!
  *  \class spm_tclRegistry
  *  \brief This abstract class provides interfaces to handles registry related operations.
  */

class ISpmRegistry : public ISpmBase
{
public:
ISpmRegistry( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmRegistry( ){}

virtual const tChar*getInterfaceName( ) const { return( "ISpmRegistry" ); }

virtual tBool bImportData( const std::string& strFileName,
                           tBool              bFileWithPath = FALSE,
                           const std::string& strKeyToCheck = "" )                                = 0;

virtual tBool bImportDataByFile( const std::string& strFileName,
                                 tBool              bFileWithPath = FALSE,
                                 const std::string& strKeyToCheck = "" )                          = 0;

virtual tBool bIsSoftwareBlockInRegistry( const std::string& strName )                            = 0;

virtual tBool bGetAllApplicationsOfSwBlock( tU16 u16SpmId,
                                            const std::string& strSwBlockName,
                                            std::map < tU16, std::vector < tU16 > >& _mapAppIds ) = 0;

virtual tBool bFindSwBlockNameOfApp( tU32         u32AppId,
                                     std::string& strSwBlockName )                                = 0;

virtual tVoid vTraceOutRegistry( const std::string& strName )                                     = 0;

virtual tBool bGetStringFromRegistry( const std::string& strPath,
                                      const std::string& strKey,
                                      std::string      & strResult )                              = 0;

virtual tBool bGetNumberFromRegistry( const std::string& strPath,
                                      const std::string& strKey,
                                      tU32             & strResult )                              = 0;

virtual tVoid vRemoveEntry( const std::string& strPath,
                            const std::string& strKey ) const                                     = 0;

virtual tBool bRemoveSoftwareBlock( const std::string& szKeyName )                                = 0;

};

