/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CriticalSection.h
  * @brief        This is header file contains functional oriented sempahore helper functions (constructor / destructor based semaphore.).
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// //////////////////////////////////////////////////////////////////////////////
// functional oriented sempahore helper functions
tVoid spm_vEnterCritical( OSAL_tSemHandle hSemId );

tBool spm_bEnterCriticalWithTimeout( OSAL_tSemHandle hSemId,
                                     tU32            u32TimeOut,
                                     tBool           fWaitTimeCheck = TRUE );

tBool spm_bReleaseCritical( OSAL_tSemHandle hSemId );

tBool spm_bIsCriticalSection( OSAL_tSemHandle hSemId );

// //////////////////////////////////////////////////////////////////////////////
// constructor / destructor based semaphore handling

/*!
  *  \class spm_tclHandleSemaphore
  *  \brief This class uses functions to enter and release a critical section.
               It create semaphore variable with the OSAL function
                 OSAL_s32SemaphoreCreate ( tCString szName,
                                           OSAL_tSemHandle* phSid,
                                           tU32 u32Value);
               It adds object oriented handling of semaphores using constructor / destructor concepts.
          This class is used by class spm_tclWorkerServer, spm_tclStartupSystem, spm_tclStartupInvestigation and spm_tclStartupCommon to handle critical section .

  */
class spm_tclHandleSemaphore
{
public:
spm_tclHandleSemaphore( OSAL_tSemHandle hSemId ){
   _hSemId = hSemId;
   if ( _hSemId != OSAL_C_INVALID_HANDLE ){
      spm_vEnterCritical( _hSemId );
   }
}

~spm_tclHandleSemaphore( ){
   if ( _hSemId != OSAL_C_INVALID_HANDLE ){
      spm_bReleaseCritical( _hSemId );
   }
}

private:
OSAL_tSemHandle _hSemId;
};

