/************************************************************************
  * FILE:         spm_IOsLinux.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "spm_ISpmBase.h"
#include <string>
#include <list>

// include type definitions of Genivi
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"

#define SPM_U32_LCM_PROXY_SHUTDOWNTYPE_NOT      ::org::genivi::NodeStateManager::LcmBasicTypes::_Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Not       /**< Client not registered for any
                                                                                                                                                     shutdown           */
#define SPM_U32_LCM_PROXY_SHUTDOWNTYPE_NORMAL   ::org::genivi::NodeStateManager::LcmBasicTypes::_Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Normal    /**< Client registered for normal
                                                                                                                                                     shutdown            */
#define SPM_U32_LCM_PROXY_SHUTDOWNTYPE_FAST     ::org::genivi::NodeStateManager::LcmBasicTypes::_Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Fast      /**< Client registered for fast
                                                                                                                                                     shutdown              */
#define SPM_U32_LCM_PROXY_SHUTDOWNTYPE_RUNUP    ::org::genivi::NodeStateManager::LcmBasicTypes::_Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Runup     /**< The shutdown type "run up"
                                                                                                                                                     can not be used for
                                                                                                                                                     registration. Clients which are
                                                                                                                                                        registered and
                                                                                                                                                     have been shut down, will
                                                                                                                                                        automatically be
                                                                                                                                                     informed about the "run up",
                                                                                                                                                        when the shut down
                                                                                                                                                     is canceled.  */

#define SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG       0x01000000U
#define SPM_U32_LCM_GET_PROXY_SHUTDOWN_TYPE( state )      ( ~SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG & state )

#define SPM_U32_LCM_SHUTDOWNTYPE_NOT      ( SPM_U32_LCM_PROXY_SHUTDOWNTYPE_NOT | SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG )
#define SPM_U32_LCM_SHUTDOWNTYPE_NORMAL   ( SPM_U32_LCM_PROXY_SHUTDOWNTYPE_NORMAL | SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG )
#define SPM_U32_LCM_SHUTDOWNTYPE_FAST     ( SPM_U32_LCM_PROXY_SHUTDOWNTYPE_FAST | SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG )
#define SPM_U32_LCM_SHUTDOWNTYPE_RUNUP    ( SPM_U32_LCM_PROXY_SHUTDOWNTYPE_RUNUP | SPM_U32_LCM_SHUTDOWNTYPE_APP_FLAG )
