/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ICcaSupplierServer.h
  * @brief        This is header file contains interfaces to evaluates cca service notifications.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_Config.h"
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"

// //////////////////////////////////////////////////////////////////////////////
// Interface to evaluate cca service messages

/*!
  *  \class ISpmCcaSupplierServer
  *  \brief This abstract class provides interfaces to evaluates cca service notifications.
          This class also supplies pure virtual functions to add or remove application ID to be notified and to change service notification.
  */
class ISpmCcaSupplierServer : public ISpmWorkerClient
{
public:
ISpmCcaSupplierServer( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmCcaSupplierServer( ){}
virtual tVoid vSupplierStateChanged( tU16 u16AppId,
                                     tU32 u32AppState,
                                     tU16 u16CoreId = 0 ) = 0;

virtual tBool bAddNotificationEntry( tU16       u16AppId,
                                     tU16       u16AppIdToBeNotified,
                                     const tU16 ServiceId = AMT_C_U16_SERVICE_UNDEF,
                                     tU16       u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                                     tU16       u16TargetSubId = AMT_C_U16_DEFAULT_NULL ) = 0;

virtual tBool bRemoveNotificationEntry( tU16       u16AppId,
                                        tU16       u16AppIdToBeNotified,
                                        const tU16 ServiceId = AMT_C_U16_SERVICE_UNDEF,
                                        tU16       u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                                        tU16       u16TargetSubId = AMT_C_U16_DEFAULT_NULL ) = 0;

virtual tVoid vAddNewService( tU16 u16ServiceId,
                              tU16 u16SupplierAppId,
                              tU16 u16CoreId = 0,
                              tU16 u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                              tU16 u16TargetSubId = AMT_C_U16_DEFAULT_NULL )                         = 0;

virtual tBool bChangeServiceNotification( const amt_tclServiceSupplierUnregister& crSrvSupplierReg,
                                          tBool                                   bAddEntry = TRUE ) = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCcaSupplierServer" ); }
};

