/*****************************************************************************
 * FILE:         spm_tclCcaServiceHandler.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  Implements the cca supplier server
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 03.08.11  | TMS Fischer       | initial version
 *
 *****************************************************************************/

#pragma once

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"    // only for the state defines

#include <algorithm>
#include <map>
#include <list>

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ICcaSupplierServer.h"

class ISpmCcaServer;
class ISpmApplicationDatabase;

struct TNotApp
{
   tU16 u16DstAppId;
   tU16 u16ServiceId;
   tU16 u16SourceSubId;
   tU16 u16TargetSubId;
   tU8 u8LastSendState;
};

class spm_tclSupplierClient
{
private:
tU16 m_u16AppId;
tU16 m_u16ServiceId;
tU16 m_u16SourceSubId;
tU16 m_u16TargetSubId;

public:
spm_tclSupplierClient( )
   : m_u16AppId( AMT_C_U16_APPID_INVALID )
   , m_u16ServiceId( AMT_C_U16_SERVICE_UNDEF )
   , m_u16SourceSubId( AMT_C_U16_SUBID_INVALID )
   , m_u16TargetSubId( AMT_C_U16_SUBID_INVALID ){}

spm_tclSupplierClient( tU16 u16AppId,
                       tU16 u16ServiceId,
                       tU16 u16SourceSubId,
                       tU16 u16TargetSubId )
   : m_u16AppId( u16AppId )
   , m_u16ServiceId( u16ServiceId )
   , m_u16SourceSubId( u16SourceSubId )
   , m_u16TargetSubId( u16TargetSubId ){}

tU16 u16GetAppId( )       const { return( m_u16AppId );       }
tU16 u16GetServiceId( )   const { return( m_u16ServiceId );   }
tU16 u16GetSourceSubId( ) const { return( m_u16SourceSubId ); }
tU16 u16GetTargetSubId( ) const { return( m_u16TargetSubId ); }

tBool operator<( const spm_tclSupplierClient& roRight ) const {

   if ( u16GetAppId( ) < roRight.u16GetAppId( ) ){
      return( TRUE );
   }

   if ( u16GetServiceId( ) < roRight.u16GetServiceId( ) ){
      return( TRUE );
   }

   if ( u16GetSourceSubId( ) < roRight.u16GetSourceSubId( ) ){
      return( TRUE );
   }

   if ( u16GetTargetSubId( ) < roRight.u16GetTargetSubId( ) ){
      return( TRUE );
   }

   return( FALSE );
}  // <

};

/*!
  *  \class spm_tclCcaSupplierHandler
  *  \brief ServiceHandler is the component within CCA Framework of SPM that implements the CCA service offered by FC_SPM.
        It creates all the properties and methods, which are then exposed to the other components external to FC_SPM for registration.
          In order to register for a service a client application has to know which server application (service supplier) offers the required service.
        That is, it has to know the AppID of the potential server.

          It uses spm_tclCcaMsgHandler class for sending supplier state.
          The spm_tclFactory object creates an instance of this class.

        It is used by spm_tclStartupCommon to add new services.
  */
class spm_tclCcaSupplierHandler : public ISpmCcaSupplierServer
{
public:
spm_tclCcaSupplierHandler( const ISpmFactory& factory );
virtual ~spm_tclCcaSupplierHandler( );

virtual tVoid vTerminate( ){}

// Implementation of interface ISpmCcaSupplierServer
virtual tVoid vSupplierStateChanged( tU16 u16AppId,
                                     tU32 u32AppState,
                                     tU16 u16CoreId = 0 );

virtual tBool bAddNotificationEntry( tU16       u16AppId,
                                     tU16       u16AppIdToBeNotified,
                                     const tU16 ServiceId = AMT_C_U16_SERVICE_UNDEF,
                                     tU16       u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                                     tU16       u16TargetSubId = AMT_C_U16_DEFAULT_NULL );

virtual tBool bRemoveNotificationEntry( tU16       u16AppId,
                                        tU16       u16AppIdToBeNotified,
                                        const tU16 ServiceId = AMT_C_U16_SERVICE_UNDEF,
                                        tU16       u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                                        tU16       u16TargetSubId = AMT_C_U16_DEFAULT_NULL );

virtual tVoid vAddNewService( tU16 u16ServiceId,
                              tU16 u16SupplierAppId,
                              tU16 u16CoreId = 0,
                              tU16 u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                              tU16 u16TargetSubId = AMT_C_U16_DEFAULT_NULL );

virtual tBool bChangeServiceNotification( const amt_tclServiceSupplierUnregister& crSrvSupplierReg,
                                          tBool                                   bAddEntry = TRUE );

virtual tVoid vCheckForUnavailableServices( );

tVoid vTraceSupplierInfo( );

tVoid vTraceErrors( );

private:
ISpmCcaServer *_poclCcaMsgHandler;

struct TNotificationEntry
{
   tU8 u8AppStatus;
   std::list < TNotApp > tNotificationList;
};

struct TAppListEntry
{
   tU16 u16ServiceApp;
   tU16 u16ServiceCore;
   tU16 u16SourceSubId;
   tU16 u16TargetSubId;
};


std::map < tU32, TNotificationEntry >          _mapSupplierNotificationTab;
std::map < tU16, std::list < TAppListEntry > > _ServiceId2AppIdMappingTab;

tBool bRemoveNotification( tU16 u16DisconnectedAppId );

tBool bFindNotificationEntry( tU16 u16SupplierAppId, tU16 u16ServiceId );

tVoid vSendNotification( tU16 u16AppId );

tBool bMoveWaitingServiceRegistration( tU16 u16ServiceId,
                                       tU16 u16SupplierAppId,
                                       tU16 u16SourceSubId = AMT_C_U16_DEFAULT_NULL,
                                       tU16 u16TargetSubId = AMT_C_U16_DEFAULT_NULL );

ISpmWorkerServer *_poclWorkerServer;

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual const tChar*getName( ) const { return( "spm_tclCcaSupplierHandler" ); }
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args );

virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
};

