///////////////////////////////////////////////////////////////////////////////
//
// File: spm_SmcSystemStateManagerDownloadLockIf.h
//
// Generated by SMC 4.6.1 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c ./LcmGeneric/framework/cca/server/SmcStatemachineDownloadLockIf.fsm
//   --protected_interface
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_SPM_SMCSYSTEMSTATEMANAGERDOWNLOADLOCKIF__
#define __INCLUDED_SPM_SMCSYSTEMSTATEMANAGERDOWNLOADLOCKIF__

namespace spm_SmcSystemStateManagerDownloadLockIf
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evLock,
   evMasterLock,
   evRelease,
   evReserve,
   evRestoreLock,
   evUse,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class LOCKEDState;
   friend class LOCKINGState;
   friend class RESERVEDState;
   friend class TOPLEVELState;
   friend class USEDState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void EntryLocked ( void* pArg ) = 0;
   virtual void EntryLocking ( void* pArg ) = 0;
   virtual void EntryReserved ( void* pArg ) = 0;
   virtual void EntryUsed ( void* pArg ) = 0;
   virtual void ExitLocked ( void* pArg ) = 0;
   virtual void ExitLocking ( void* pArg ) = 0;
   virtual void ExitReserved ( void* pArg ) = 0;
   virtual void ExitUsed ( void* pArg ) = 0;
   virtual void vDeleteLockPersistently ( void* pArg ) = 0;
   virtual void vRemoveLock ( void* pArg ) = 0;
   virtual void vSaveLockPersistently ( void* pArg ) = 0;
   virtual void vUpdateOwner ( void* pArg ) = 0;

   // FSM guards
   virtual bool isExistingUser ( void* pArg ) = 0;
   virtual bool isNotExistingUser ( void* pArg ) = 0;
   virtual bool isNotOwner ( void* pArg ) = 0;
   virtual bool isNotUserListEmpty ( void* pArg ) = 0;
   virtual bool isOwner ( void* pArg ) = 0;
   virtual bool isUserListEmpty ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'spm_SmcSystemStateManagerDownloadLockIf'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    virtual void init ( void* pInitArg=0 );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
