///////////////////////////////////////////////////////////////////////////////
//
// File: spm_SmcSystemStateManagerDownloadLockIf.cpp
//
// Generated by SMC 4.6.1 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c ./LcmGeneric/framework/cca/server/SmcStatemachineDownloadLockIf.fsm
//   --protected_interface
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_SPM_SMCSYSTEMSTATEMANAGERDOWNLOADLOCKIF__
#include "spm_SmcSystemStateManagerDownloadLockIf.h"
#endif

namespace spm_SmcSystemStateManagerDownloadLockIf
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRelease ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReserve ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUse ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );


protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! constructor for a substate of the given superstate
   FsmState ( FsmSuperState& parent );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! class constructor for a superstate without parent
   FsmSuperState ( FsmState& defState, bool histEnable=false );
   //! class constructor for a superstate with parent
   FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable=false );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
   // Assignment fixing for Coverity warning
   FsmSuperState& operator= (const FsmSuperState& coRef);
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: LOCKEDState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class LOCKEDState
   : public FsmState
{
public:
   //! default constructor
   LOCKEDState ( void );

   LOCKEDState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRelease ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* LOCKEDState::mStateName = "LOCKED";

///////////////////////////////////////////////////////////////////////////////
//
// Class: LOCKINGState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class LOCKINGState
   : public FsmState
{
public:
   //! default constructor
   LOCKINGState ( void );

   LOCKINGState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRelease ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* LOCKINGState::mStateName = "LOCKING";

///////////////////////////////////////////////////////////////////////////////
//
// Class: RESERVEDState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class RESERVEDState
   : public FsmState
{
public:
   //! default constructor
   RESERVEDState ( void );

   RESERVEDState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RESERVEDState::mStateName = "RESERVED";

///////////////////////////////////////////////////////////////////////////////
//
// Class: TOPLEVELState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class TOPLEVELState
   : public FsmSuperState
{
public:
   //! default constructor
   TOPLEVELState ( void );

   TOPLEVELState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TOPLEVELState::mStateName = "TOPLEVEL";

///////////////////////////////////////////////////////////////////////////////
//
// Class: USEDState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class USEDState
   : public FsmState
{
public:
   //! default constructor
   USEDState ( void );

   USEDState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReserve ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* USEDState::mStateName = "USED";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    void init ( void* pInitArg=0 );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    LOCKEDState oLOCKEDState;
    LOCKINGState oLOCKINGState;
    RESERVEDState oRESERVEDState;
    TOPLEVELState oTOPLEVELState;
    USEDState oUSEDState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evLock ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evLock *** 
}

void
FsmState::evMasterLock ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evMasterLock *** 
}

void
FsmState::evRelease ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRelease *** 
}

void
FsmState::evReserve ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReserve *** 
}

void
FsmState::evRestoreLock ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRestoreLock *** 
}

void
FsmState::evUse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUse *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::FsmState ( FsmSuperState& parent )
   : mpParent(&parent)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( FsmState& defState, bool histEnable )
   : _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable )
   : FsmState(parent),
     _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: LOCKEDState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

LOCKEDState::LOCKEDState ( void )
{}

LOCKEDState::LOCKEDState ( FsmBody& b )
   : FsmState(b.oTOPLEVELState) 
{}

void
LOCKEDState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.EntryLocked(pArg);
}

void
LOCKEDState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ExitLocked(pArg);
}

void
LOCKEDState::evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vUpdateOwner(pArg);
   s.vSaveLockPersistently(pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
LOCKEDState::evRelease ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isOwner(pArg) )
   {
        // transition Actions
        s.vDeleteLockPersistently(pArg);
        s.vRemoveLock(pArg);
        // this is an internal transition
    }
}

void
LOCKEDState::evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
LOCKEDState::evUse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isOwner(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vDeleteLockPersistently(pArg);
        b.setState(b.oUSEDState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: LOCKINGState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

LOCKINGState::LOCKINGState ( void )
{}

LOCKINGState::LOCKINGState ( FsmBody& b )
   : FsmState(b.oTOPLEVELState) 
{}

void
LOCKINGState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.EntryLocking(pArg);
}

void
LOCKINGState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ExitLocking(pArg);
}

void
LOCKINGState::evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vUpdateOwner(pArg);
   s.vSaveLockPersistently(pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
LOCKINGState::evRelease ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isExistingUser(pArg) && s.isNotOwner(pArg) && s.isNotUserListEmpty(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oLOCKINGState,pArg);
    } 
    else if ( s.isExistingUser(pArg) && s.isNotOwner(pArg) && s.isUserListEmpty(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vSaveLockPersistently(pArg);
        b.setState(b.oLOCKEDState,pArg);
    } 
    else if ( s.isOwner(pArg) )
   {
        // transition Actions
        s.vRemoveLock(pArg);
        // this is an internal transition
    }
}

void
LOCKINGState::evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
LOCKINGState::evUse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isOwner(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oUSEDState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: RESERVEDState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

RESERVEDState::RESERVEDState ( void )
{}

RESERVEDState::RESERVEDState ( FsmBody& b )
   : FsmState(b.oTOPLEVELState) 
{}

void
RESERVEDState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.EntryReserved(pArg);
}

void
RESERVEDState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ExitReserved(pArg);
}

void
RESERVEDState::evLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isOwner(pArg) && s.isNotUserListEmpty(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oLOCKINGState,pArg);
    } 
    else if ( s.isOwner(pArg) && s.isUserListEmpty(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vSaveLockPersistently(pArg);
        b.setState(b.oLOCKEDState,pArg);
    }
}

void
RESERVEDState::evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vUpdateOwner(pArg);
   s.vSaveLockPersistently(pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
RESERVEDState::evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
RESERVEDState::evUse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isExistingUser(pArg) && s.isOwner(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oUSEDState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: TOPLEVELState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

TOPLEVELState::TOPLEVELState ( void )
{}

TOPLEVELState::TOPLEVELState ( FsmBody& b )
   : FsmSuperState(b.oUSEDState, false)
{}

void
TOPLEVELState::evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vUpdateOwner(pArg);
   s.vSaveLockPersistently(pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
TOPLEVELState::evRestoreLock ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oLOCKEDState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: USEDState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

USEDState::USEDState ( void )
{}

USEDState::USEDState ( FsmBody& b )
   : FsmState(b.oTOPLEVELState) 
{}

void
USEDState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.EntryUsed(pArg);
}

void
USEDState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ExitUsed(pArg);
}

void
USEDState::evMasterLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vUpdateOwner(pArg);
   s.vSaveLockPersistently(pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
USEDState::evReserve ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isExistingUser(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vUpdateOwner(pArg);
        b.setState(b.oRESERVEDState,pArg);
    }
}

void
USEDState::evRestoreLock ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oLOCKEDState,pArg);
}

void
USEDState::evUse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isNotExistingUser(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oUSEDState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{
    mpBody = new FsmBody();
}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

void
Fsm::init ( void* pInitArg )
{
    
    if ( mpBody )
    {
        // connect the body with its frontend
        mpBody->connect(this);
        {
            mpBody->init(pInitArg);
        }
    }
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      oLOCKEDState(*this),
      oLOCKINGState(*this),
      oRESERVEDState(*this),
      oTOPLEVELState(*this),
      oUSEDState(*this),
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

void
FsmBody::init ( void* pInitArg )
{
    oLOCKEDState.reset();
    oLOCKINGState.reset();
    oRESERVEDState.reset();
    oTOPLEVELState.reset();
    oUSEDState.reset();

    setState(oTOPLEVELState,pInitArg);
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evLock:
            if ( mpState ) mpState->evLock(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evMasterLock:
            if ( mpState ) mpState->evMasterLock(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRelease:
            if ( mpState ) mpState->evRelease(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReserve:
            if ( mpState ) mpState->evReserve(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRestoreLock:
            if ( mpState ) mpState->evRestoreLock(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUse:
            if ( mpState ) mpState->evUse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evLock",
      "evMasterLock",
      "evRelease",
      "evReserve",
      "evRestoreLock",
      "evUse",
   };

   return eventNames[event];
}


} // namespace
