/*!
  * \file spm_CcaServiceHandlerMsg.cpp
  *  \brief
  *    Implementation of specifif SPM CCA service messages.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * 1.0 |  24.07.2004  | Klaus-Peter Kollai     | initial version
  ******
  */

#include "spm_Config.h"
#include "spm_CcaServiceHandlerMsg.h"

// Class used to report error
spm_tclServiceErrorStatus::spm_tclServiceErrorStatus   ( tU16 nSource,
                                                         tU16 nTarget,
                                                         tU16 u16RegID,
                                                         tU16 u16CmdCtr,
                                                         tU16 u16ServiceID,
                                                         tU16 u16FuntionID,
                                                         tU8  u8ACT,
                                                         tU16 u16SourceSub,
                                                         tU16 u16TargetSub ) : amt_tclServiceData( ){
   if ( bAllocateMessage( ) ){
      vInitServiceData( nSource,                           // Source,
                        nTarget,                           // Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                                 // StreamCounter
                        u16RegID,                          // RegisterID
                        u16CmdCtr,                         // nCmdCounter,
                        u16ServiceID,                      // nServiceID,
                        u16FuntionID,                      // nFunctionID,
                        AMT_C_U8_CCAMSG_OPCODE_ERROR,      // OpCode
                        u8ACT,                             // asynchronous completion token
                        u16SourceSub,                      // SubID of source
                        u16TargetSub );                    // SubID of target
   }
}

