/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandlerFiParam.h
  * @brief        Automated generation of method and property variables from
  *               System Power Management Service, Application Functional Interface
  *               Version : $Revision:   1.15  $
  *               Author  : Klaus-Peter Kollai
  *               Title   : SPM_CORE_FI
  *               Date    : $Date:  08.08.2018  $
  * @copyright    (C) 2017-2020 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////


// property variables
spm_Property < spm_corefi_tclMsgSystemStateStatus >          _systemState;
spm_Property < spm_corefi_tclMsgUpdateLockStatesStatus >     _updateLockStates;
spm_PropertySubStates                                        _subStates;
spm_PropertyPhoneMuteState                                   _phoneMuteState;
spm_PropertyOnTipperState                                    _onTipperState;
spm_PropertyMapDownloadLockState                             _mapDownloadLockState;
spm_PropertyStandbyTime                                      _standbyTime;
spm_PropertyPersitentStandbyTime                             _persitentStandbyTime;
spm_PropertyIgnitionOffTime                                  _ignitionOffTime;
spm_PropertyDoorOpenTime                                     _doorOpenTime;
spm_PropertyClockDisplayTime                                 _clockDisplayTime;
spm_PropertySystemStateTime                                  _systemStateTime;
spm_PropertyProcessList                                      _processList;
spm_PropertyWakeupReason                                     _wakeupReason;
spm_PropertyStartupReason                                    _startupReason;
spm_PropertyConnectToBattery                                 _connectToBattery;
spm_Property < spm_corefi_tclMsgCodeRequestStateStatus >     _codeRequestState;
spm_Property < spm_corefi_tclMsgCvmEventStatus >             _cvmEvent;
spm_PropertyUBatSense                                        _uBatSense;
spm_PropertyDevicePowerOnTime                                _devicePowerOnTime;
spm_PropertyLastSystemRuntime                                _lastSystemRuntime;
spm_PropertyCurrentSystemRuntime                             _currentSystemRuntime;
spm_PropertyResetList                                        _resetList;
spm_PropertyResetCounter                                     _resetCounter;
spm_PropertyTransportModeList                                _transportModeList;
spm_PropertyResetHistory                                     _resetHistory;
spm_PropertyWakeupHistory                                    _wakeupHistory;
spm_PropertyStateHistory                                     _stateHistory;
spm_PropertyErrStateHistory01                                _errStateHistory01;
spm_PropertyErrStateHistory02                                _errStateHistory02;
spm_PropertyErrStateHistory03                                _errStateHistory03;
spm_PropertyErrStateHistory04                                _errStateHistory04;
spm_PropertyErrStateHistory05                                _errStateHistory05;
spm_PropertySwitchOnHistory                                  _switchOnHistory;
spm_PropertyDeviceOnCounter                                  _deviceOnCounter;
spm_PropertyVoltageEventCounter                              _voltageEventCounter;
spm_PropertyVoltageRangeHistogram                            _voltageRangeHistogram;
spm_PropertyCpuUsageStatistic                                _cpuUsageStatistic;
spm_PropertyRamUsageStatistic                                _ramUsageStatistic;
spm_PropertyStartupTimeStatistic                             _startupTimeStatistic;
spm_PropertySWVersionStatistic                               _sWVersionStatistic;
spm_Property < spm_corefi_tclMsgRunlevelStateStatus >        _runlevelState;
spm_PropertyRestart                                          _restart;
spm_Property < spm_corefi_tclMsgHmiStateStatus >             _hmiState;
spm_Property < spm_corefi_tclMsgDimStateStatus >             _dimState;
spm_Property < spm_corefi_tclMsgDimmingStateStatus >         _dimmingState;
spm_Property < spm_corefi_tclMsgBluetoothStateStatus >       _bluetoothState;
spm_Property < spm_corefi_tclMsgAudioStateStatus >           _audioState;
spm_Property < spm_corefi_tclMsgSpiStateStatus >             _spiState;
spm_Property < spm_corefi_tclMsgTunerStateStatus >           _tunerState;
spm_PropertyOnOffReason                                      _onOffReason;
spm_PropertyWakeupList                                       _wakeupList;
spm_Property < spm_corefi_tclMsgVehicleIDStatus >            _vehicleID;

// method variables
spm_MethodSystemMode                                         _systemMode;
spm_MethodDownloadLockState                                  _downloadLockState;
spm_MethodUpdateLock                                         _updateLock;
spm_MethodOnOffTrigger                                       _onOffTrigger;
spm_MethodStartProcess                                       _startProcess;
spm_MethodStopProcess                                        _stopProcess;
spm_MethodRestartProcess                                     _restartProcess;
spm_MethodStartUpSyncPointReached                            _startUpSyncPointReached;
spm_MethodClearList                                          _clearList;
spm_MethodSpecificSWVersionStatistic                         _specificSWVersionStatistic;
spm_MethodRestartSystem                                      _restartSystem;
spm_MethodAudioSourceChange                                  _audioSourceChange;
spm_MethodShutdownAndTerminateCcaApps                        _shutdownAndTerminateCcaApps;

