/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandlerAccess.h
  * @brief        Automated generation of method and property variables from
  *               System Power Management Service, Application Functional Interface
  *               Version : $Revision:   1.15  $
  *               Author  : Klaus-Peter Kollai
  *               Title   : SPM_CORE_FI
  *               Date    : $Date:  08.08.2018  $
  * @copyright    (C) 2017-2020 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_CcaMethods.h"    // "spm_CcaProperties.h" is already included in "spm_CcaMethods.h"

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////

class spm_PropertySubStates : public spm_Property < spm_corefi_tclMsgSubStatesStatus >
{
public:
virtual const spm_PropertySubStates& operator=(const spm_corefi_tclMsgSubStatesStatus& op);

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyPhoneMuteState : public spm_Property < spm_corefi_tclMsgPhoneMuteStateStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyOnTipperState : public spm_Property < spm_corefi_tclMsgOnTipperStateStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyMapDownloadLockState : public spm_Property < spm_corefi_tclMsgMapDownloadLockStateStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyStandbyTime : public spm_Property < spm_corefi_tclMsgStandbyTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyPersitentStandbyTime : public spm_Property < spm_corefi_tclMsgPersitentStandbyTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyIgnitionOffTime : public spm_Property < spm_corefi_tclMsgIgnitionOffTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyDoorOpenTime : public spm_Property < spm_corefi_tclMsgDoorOpenTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyClockDisplayTime : public spm_Property < spm_corefi_tclMsgClockDisplayTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertySystemStateTime : public spm_Property < spm_corefi_tclMsgSystemStateTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyProcessList : public spm_Property < spm_corefi_tclMsgProcessListStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyWakeupReason : public spm_Property < spm_corefi_tclMsgWakeupReasonStatus >
{
public:
virtual const spm_PropertyWakeupReason& operator=(const spm_corefi_tclMsgWakeupReasonStatus& op);

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyStartupReason : public spm_Property < spm_corefi_tclMsgStartupReasonStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyConnectToBattery : public spm_Property < spm_corefi_tclMsgConnectToBatteryStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyUBatSense : public spm_Property < spm_corefi_tclMsgUBatSenseStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyDevicePowerOnTime : public spm_Property < spm_corefi_tclMsgDevicePowerOnTimeStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyLastSystemRuntime : public spm_Property < spm_corefi_tclMsgLastSystemRuntimeStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyCurrentSystemRuntime : public spm_Property < spm_corefi_tclMsgCurrentSystemRuntimeStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyResetList : public spm_Property < spm_corefi_tclMsgResetListStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyResetCounter : public spm_Property < spm_corefi_tclMsgResetCounterStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyTransportModeList : public spm_Property < spm_corefi_tclMsgTransportModeListStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyResetHistory : public spm_Property < spm_corefi_tclMsgResetHistoryStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyWakeupHistory : public spm_Property < spm_corefi_tclMsgWakeupHistoryStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyStateHistory : public spm_Property < spm_corefi_tclMsgStateHistoryStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyErrStateHistory01 : public spm_Property < spm_corefi_tclMsgErrStateHistory01Status >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyErrStateHistory02 : public spm_Property < spm_corefi_tclMsgErrStateHistory02Status >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyErrStateHistory03 : public spm_Property < spm_corefi_tclMsgErrStateHistory03Status >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyErrStateHistory04 : public spm_Property < spm_corefi_tclMsgErrStateHistory04Status >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyErrStateHistory05 : public spm_Property < spm_corefi_tclMsgErrStateHistory05Status >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertySwitchOnHistory : public spm_Property < spm_corefi_tclMsgSwitchOnHistoryStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyDeviceOnCounter : public spm_Property < spm_corefi_tclMsgDeviceOnCounterStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyVoltageEventCounter : public spm_Property < spm_corefi_tclMsgVoltageEventCounterStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyVoltageRangeHistogram : public spm_Property < spm_corefi_tclMsgVoltageRangeHistogramStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyCpuUsageStatistic : public spm_Property < spm_corefi_tclMsgCpuUsageStatisticStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyRamUsageStatistic : public spm_Property < spm_corefi_tclMsgRamUsageStatisticStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyStartupTimeStatistic : public spm_Property < spm_corefi_tclMsgStartupTimeStatisticStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertySWVersionStatistic : public spm_Property < spm_corefi_tclMsgSWVersionStatisticStatus >
{

private:
virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyRestart : public spm_Property < spm_corefi_tclMsgRestartStatus >
{
public:
virtual const spm_PropertyRestart& operator=(const spm_corefi_tclMsgRestartStatus& op);

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyOnOffReason : public spm_Property < spm_corefi_tclMsgOnOffReasonStatus >
{
public:
virtual const spm_PropertyOnOffReason& operator=(const spm_corefi_tclMsgOnOffReasonStatus& op);

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tU8 u8SetOperationPrj(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyWakeupList : public spm_Property < spm_corefi_tclMsgWakeupListStatus >
{

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};


class spm_MethodSystemMode : public spm_Method < spm_corefi_tclMsgSystemModeMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodDownloadLockState : public spm_Method < spm_corefi_tclMsgDownloadLockStateMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodUpdateLock : public spm_Method < spm_corefi_tclMsgUpdateLockMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodOnOffTrigger : public spm_Method < spm_corefi_tclMsgOnOffTriggerMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodStartProcess : public spm_Method < spm_corefi_tclMsgStartProcessMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodStopProcess : public spm_Method < spm_corefi_tclMsgStopProcessMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodRestartProcess : public spm_Method < spm_corefi_tclMsgRestartProcessMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodStartUpSyncPointReached : public spm_Method < spm_corefi_tclMsgStartUpSyncPointReachedMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodClearList : public spm_Method < spm_corefi_tclMsgClearListMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodSpecificSWVersionStatistic : public spm_Method < spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodRestartSystem : public spm_Method < spm_corefi_tclMsgRestartSystemMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

class spm_MethodAudioSourceChange : public spm_Method < spm_corefi_tclMsgAudioSourceChangeMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};






class spm_MethodShutdownAndTerminateCcaApps : public spm_Method < spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult >
{

private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};









// spm_tclCcaServiceHandlerAccess_refactorCode_spm: user specific code start
    tU8 u8ErrStateHistorySetOperation( void );
    template<typename T>
    tVoid vErrStateHistoryGetOperation(T oHistory,spm_fi_tcl_StateChangeElement &oStateElement,tUInt pos);
    #include "spm_StatisticTypes.h"
    tVoid vWakeupElementToFiType( TSpmWakeupStatisticsData *tWakeupData, spm_fi_tcl_WakeupElement *fiWakeupElement );
    tVoid vSwitchOnElemToFiType( TSpmSwitchOnStatisticsData *tSwitchOnData, spm_fi_tcl_SwitchOnElement *fiSwitchOnElement );
    tVoid vResetElementToFiType( TSpmResetElem *tResetElemData, spm_fi_tcl_ResetElement *fiResetElement );
    tVoid vSystemStateElementToFiType( TSpmSystemStateStatisticsData *tSystemStateData, spm_fi_tcl_StateChangeElement *fiStateChangeElement );
    tVoid vResetInfoToFiType( TSpmResetStatisticsData *tResetInfoData, spm_fi_tcl_SPM_ResetInfoStatisticData *fiResetInfo );
    tVoid vSystemLoadStatistcToFiType( TSpmSystemLoadStatisticsData  *tSystemLoadData, spm_fi_tcl_SPM_SystemStatisticsData *fiSystemLoadData );
    tVoid vSWVersionStatisticToFiType( TSpmSoftwareVersionStatisticsData *tSWVersionData, spm_fi_tcl_SPM_SWVersionStatisticData *fiSWVersionData );
// spm_tclCcaServiceHandlerAccess_refactorCode_spm: user specific code end
