/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ICcaServer.h
  * @brief        This is header file contains interface functions for CcaServer.
  *               interfaces to send cca, power messages to other components.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"                        // use CCA messages

#include "spm_IWorkerClient.h"
#include "spm_baseClass.h"

// //////////////////////////////////////////////////////////////////////////////
// Interface to send messages to other components

/*!
  *  \class ISpmCcaServer
  *  \brief This abstract class provides interfaces to send messages to other components.
          This class delivers pure virtual functions to post power messages to target ID.

  */
class ISpmCcaServer : public spm_tclActive
   , public ISpmWorkerClient
{
public:
ISpmCcaServer( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmCcaServer( ){}
virtual tBool bPostMessage( amt_tclBaseMessage *poMessage,
                            tBool               bTrace = TRUE ) = 0;

virtual tVoid vApplicationEndSuccessful( tU16 u16AppID )        = 0;

virtual tBool bPostPowerMessage( tU16 u16TargetID,
                                 tU16 u16PowerType,
                                 tU32 u32PowerData1,
                                 tU32 u32PowerData2 )           = 0;

virtual tBool bCheckForCcaInContext( tVoid ) = 0;
virtual tVoid main( tVoid )                  = 0;

virtual tVoid vStart( const std::string& strName,
                      tU32               u32Prio,
                      tU32               u32Stack,
                      tU32               u32MaxMsgQueueLength ) = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCcaServer" ); }
};

