/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_TransportmodeStatistics.h
  * @brief        This is header file contains functions related to Transportmode Statistics of system..
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"

#define SPM_U32_TRANSPORT_MODE_OFF      0x0000
#define SPM_U32_TRANSPORT_MODE_ON       0x0001

/*!
  *  \class spm_tclTransportmodeStatistics
  *  \brief This class works for transportmode statistics of system.
          It uses class dp_tclSpmDpEngDataTpHistory to set , erase and trace statistics data.

        This is used by class spm_tclSubStateHandler for setting TransportmodeStatistics data.

          The spm_tclFactory object creates an instance of this class.
  */
class spm_tclTransportmodeStatistics : public ISpmStatistics
{
public:
spm_tclTransportmodeStatistics( const ISpmFactory& factory );
virtual ~spm_tclTransportmodeStatistics( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void */*pStatisticsData*/,
                        tU32  /*u32ObjectSize = 0*/ ) const { } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
virtual const tChar*getName( ) const { return( "spm_tclTransportmodeStatistics" ); }

};

